% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_idp_admin1_data.R
\name{get_idp_admin1_data}
\alias{get_idp_admin1_data}
\title{Fetch IDP Admin1 Data}
\usage{
get_idp_admin1_data(
  Operation = NULL,
  CountryName = NULL,
  Admin0Pcode = NULL,
  Admin1Name = NULL,
  Admin1Pcode = NULL,
  FromReportingDate = NULL,
  ToReportingDate = NULL,
  FromRoundNumber = 0,
  ToRoundNumber = 0
)
}
\arguments{
\item{Operation}{Optional; Name of the DTM operation for which the data was collected.}

\item{CountryName}{Optional; Name of the country where the data was collected.}

\item{Admin0Pcode}{Optional; Country code (ISO 3166-1 alpha-3).}

\item{Admin1Name}{Optional; Name of level 1 administrative boundaries.}

\item{Admin1Pcode}{Optional; Place code of level 1 administrative boundaries.}

\item{FromReportingDate}{Optional; Start date for the reporting period (format: 'YYYY-MM-DD').}

\item{ToReportingDate}{Optional; End date for the reporting period (format: 'YYYY-MM-DD').}

\item{FromRoundNumber}{Optional; Starting round number for the data collection range.}

\item{ToRoundNumber}{Optional; Ending round number for the data collection range.}
}
\value{
A data frame containing the IDP Admin1 data matching the specified criteria.
}
\description{
Retrieve IDP data at Admin 1 level based on specified parameters.
At least one of the following parameters must be provided: Operation, CountryName, or Admin0Pcode.
}
\examples{
\dontrun{
# Fetch IDP data at Admin Level 1
idp_admin1_df <- get_idp_admin1_data(CountryName='Sudan', Admin1Name="Blue Nile")
head(idp_admin1_df)
}
}
