% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtrackr.R
\name{include_any}
\alias{include_any}
\title{Include any items matching a criteria}
\usage{
include_any(
  .data,
  ...,
  .headline = .defaultHeadline(),
  na.rm = TRUE,
  .type = "inclusion",
  .asOffshoot = FALSE
)
}
\arguments{
\item{.data}{\itemize{
\item a dataframe which may be grouped
}}

\item{...}{\itemize{
\item a dplyr filter specification as a formula where the RHS is a glue specification, defining the message. This can refer to grouping variables,
variables from the environment and \{.included\} and \{.matched\} or \{.missing\} (included = matched+missing), \{.count\} and \{.total\} - group and overall counts respectively, e.g. "excluding \{.matched\} items and \{.missing\} with missing values".
}}

\item{.headline}{\itemize{
\item a glue specification which can refer to grouping variables of .data, or any variables defined in the calling environment
}}

\item{na.rm}{\itemize{
\item (default FALSE) if the filter cannot be evaluated for a row count that row as missing and either exclude it (TRUE) or don't exclude it (FALSE)
}}

\item{.type}{\itemize{
\item default "exclusion": used to define formatting
}}

\item{.asOffshoot}{\itemize{
\item do you want this comment to be an offshoot of the main flow (default = TRUE).
}}
}
\value{
the filtered .data dataframe with the history graph updated with the summary of included items as a new stage
}
\description{
Apply a set of inclusion criteria and dplyr::summarise the actions of the filter to the dtrackr history graph
Because of the ... filter specification, all parameters MUST BE NAMED.
The criteria work in an alternative manner, i.e. the results include anything that match any of the criteria.
If na.rm = TRUE they also keep anything that cannot be evaluated by a criteria - that may be true.
}
\examples{
library(dplyr)
iris \%>\% track() \%>\% include_any(
      Petal.Length > 5 ~ "{.included} long ones",
      Petal.Length < 2 ~ "{.included} short ones"
) \%>\% history()
}
