% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtrackr.R
\name{add_tally}
\alias{add_tally}
\title{dplyr modifying operations}
\usage{
add_tally(x, ..., .messages = "", .headline = "", .tag = NULL)
}
\arguments{
\item{x}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr).}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Variables to group
by.
  Named arguments passed on to \code{\link[dplyr:count]{dplyr::add_tally}}\describe{
    \item{\code{wt}}{<\code{\link[rlang:args_data_masking]{data-masking}}> Frequency weights.
Can be \code{NULL} or a variable:
\itemize{
\item If \code{NULL} (the default), counts the number of rows in each group.
\item If a variable, computes \code{sum(wt)} for each group.
}}
\item{\code{sort}}{If \code{TRUE}, will show the largest groups at the top.}
\item{\code{name}}{The name of the new column in the output.

If omitted, it will default to \code{n}. If there's already a column called \code{n},
it will use \code{nn}. If there's a column called \code{n} and \code{nn}, it'll use
\code{nnn}, and so on, adding \code{n}s until it gets a new name.}
\item{\code{.drop}}{Handling of factor levels that don't appear in the data, passed
on to \code{\link[dplyr:group_by]{group_by()}}.

For \code{count()}: if \code{FALSE} will include counts for empty groups (i.e. for
levels of factors that don't exist in the data).

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} For \code{add_count()}: deprecated since it
can't actually affect the output.}
}}

\item{.messages}{a set of glue specs. The glue code can use any global
variable, grouping variable, \{.new_cols\} or \{.dropped_cols\} for changes to
columns, \{.cols\} for the output column names, or \{.strata\}. Defaults to nothing.}

\item{.headline}{a headline glue spec. The glue code can use any global
variable, grouping variable, \{.new_cols\}, \{.dropped_cols\}, \{.cols\} or \{.strata\}.
Defaults to nothing.}

\item{.tag}{if you want the summary data from this step in the future then
give it a name with .tag.}
}
\value{
the \code{.data} dataframe after being modified by the \code{dplyr} equivalent
function, but with the history graph updated with a new stage if the
\code{.messages} or \code{.headline} parameter is not empty.
}
\description{
See \code{\link[dplyr:mutate]{dplyr::mutate()}}, \code{\link[dplyr:count]{dplyr::add_count()}}, \code{\link[dplyr:count]{dplyr::add_tally()}},
\code{\link[dplyr:transmute]{dplyr::transmute()}}, \code{\link[dplyr:select]{dplyr::select()}}, \code{\link[dplyr:relocate]{dplyr::relocate()}},
\code{\link[dplyr:rename]{dplyr::rename()}} \code{\link[dplyr:rename]{dplyr::rename_with()}}, \code{\link[dplyr:arrange]{dplyr::arrange()}} for more details
on underlying functions. \code{dtrackr} provides equivalent functions for
mutating, selecting and renaming a data set which act in the same way as
\code{dplyr}. \code{mutate} / \code{select} / \code{rename} generally don't add anything in terms
of provenance of data so the default behaviour is to miss these out of the
\code{dtrackr} history. This can be overridden with the \code{.messages}, or
\code{.headline} values in which case they behave just like a \code{comment()}.
}
\examples{
library(dplyr)
library(dtrackr)

# mutate and other functions are unitary operations that generally change
# the structure but not size of a dataframe. In dtrackr these are by ignored
# by default but we can change that so that their behaviour is obvious.

# add_count
# adding in a count or tally column as a new column
iris \%>\%
  track() \%>\%
  add_count(Species, name="new_count_total",
            .messages="{.new_cols}",
            # .messages="{.cols}",
            .headline="New columns from add_count:") \%>\%
  history()

# add_tally
iris \%>\%
  track() \%>\%
  group_by(Species) \%>\%
  dtrackr::add_tally(wt=Petal.Length, name="new_tally_total",
            .messages="{.new_cols}",
            .headline="New columns from add_tally:") \%>\%
  history()



}
\seealso{
dplyr::add_tally()
}
