% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/month-decimal.R
\name{dtt_month_decimal}
\alias{dtt_month_decimal}
\alias{dtt_month_decimal.Date}
\alias{dtt_month_decimal.POSIXct}
\title{Get Decimal Month Values}
\usage{
dtt_month_decimal(x, ...)

\method{dtt_month_decimal}{Date}(x, ...)

\method{dtt_month_decimal}{POSIXct}(x, ...)
}
\arguments{
\item{x}{A date/time vector.}

\item{...}{Unused.}
}
\value{
A numeric vector.
}
\description{
Gets decimal month values for date/time vectors.
}
\section{Methods (by class)}{
\itemize{
\item \code{dtt_month_decimal(Date)}: Get numeric vector of decimal year values for a
Date vector

\item \code{dtt_month_decimal(POSIXct)}: Get numeric vector of decimal year values for a
POSIXct vector

}}
\examples{
x <- as.POSIXct("1990-01-03 10:00:01")
dtt_month_decimal(x)
}
\seealso{
\code{\link[=dtt_month]{dtt_month()}}

Other decimal: 
\code{\link{dtt_day_decimal}()},
\code{\link{dtt_doy_decimal}()},
\code{\link{dtt_hour_decimal}()},
\code{\link{dtt_minute_decimal}()},
\code{\link{dtt_year_decimal}()}
}
\concept{decimal}
