% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot-dtwSat.R
\docType{methods}
\name{plotAlignment}
\alias{plotAlignment}
\title{Plotting alignment of dtwSat object}
\usage{
plotAlignment(x, n, attr = 1, shift = 0.5)
}
\arguments{
\item{x}{An \code{\link[dtwSat]{dtwSat-class}} object}

\item{n}{An integer, the index of the alignment to plot}

\item{attr}{An integer or a character indicating the attribute
for plotting, \emph{i.e.} the column of the \code{query}. Default is 1}

\item{shift}{A number, it shifts the pattern position in the \code{x}
direction. Default is 0.5}
}
\value{
object of class \link[ggplot2]{ggplot}
}
\description{
Method for plotting the alignments of
Time-Weighted DTW analysis
}
\examples{
names(query.list)
alig = dtwSat(query.list[["Soybean"]], template, weight = "logistic",
       alpha = 0.1, beta = 100, n.alignments = 4, keep = TRUE)
gp = plotAlignment(alig, n=1, attr="evi", shift=0.5)
gp
}
\author{
Victor Maus, \email{vwmaus1@gmail.com}
}
\seealso{
\code{\link[dtwSat]{dtwSat}}, \code{\link[dtwSat]{plotPath}},
\code{\link[dtwSat]{plotClassify}}, and \code{\link[dtwSat]{plotCostMatrix}}
}

