% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot-dtwSat.R
\name{plotCostMatrix}
\alias{plotCostMatrix}
\title{Plotting cost matrices}
\usage{
plotCostMatrix(x, matrix.name = "costMatrix", normalize = FALSE)
}
\arguments{
\item{x}{An \code{\link[dtwSat]{dtwSat-class}} object}

\item{matrix.name}{A character. The name of the matrix to plot,
"costMatrix", "localMatrix", or "timeWeight".
Default is "costMatrix"}

\item{normalize}{Plot normalized distance. Default is FALSE}
}
\value{
object of class \link[ggplot2]{ggplot}
}
\description{
Method for plotting the internal matrices
}
\examples{
names(query.list)
alig = twdtw(query.list[["Soybean"]], template, weight = "logistic",
               alpha = 0.1, beta = 100, keep=TRUE)

gp = plotCostMatrix(x=alig, matrix.name="localMatrix")
gp

gp = plotCostMatrix(x=alig, matrix.name="timeWeight")
gp

gp = plotCostMatrix(x=alig, matrix.name="costMatrix")
gp
}
\author{
Victor Maus, \email{vwmaus1@gmail.com}
}
\seealso{
\code{\link[dtwSat]{dtwSat}},
\code{\link[dtwSat]{plotPath}}, \code{\link[dtwSat]{plotAlignment}},
and \code{\link[dtwSat]{plotClassify}}
}

