% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAdjustedArea.R
\name{plotAdjustedArea}
\alias{plotAdjustedArea}
\title{Plotting area and uncertainty}
\usage{
plotAdjustedArea(x, perc = TRUE, time.labels = NULL, category.name = NULL,
  category.type = NULL)
}
\arguments{
\item{x}{An object of class \code{\link[dtwSat]{twdtwAssessment}} or 
\code{\link[dtwSat]{twdtwCrossValidation}}.}

\item{perc}{if TRUE shows the results in percent of area. Otherwise shows the 
area in the map units or km2 for no project raster. Default is TRUE.}

\item{time.labels}{a character or numeric for the time periods or NULL to 
aggregate all classified periods in the same plot. Default is NULL. Used 
if \code{x} is \code{\link[dtwSat]{twdtwAssessment}}.}

\item{category.name}{a character vector defining the class names. If NULL
then use the classe names in the object \code{x}. Default is NULL.}

\item{category.type}{a character defining the categories type "numeric" 
or "letter", if NULL then use the class names. Default is NULL.}
}
\value{
A \link[ggplot2]{ggplot} object.
}
\description{
Method for plotting area and uncertainty.
}
\examples{
\dontrun{

# See ?twdtwAssess

plotAdjustedArea(twdtw_assess)

plotAdjustedArea(twdtw_assess, category.type="letter")

}

}
\seealso{
\code{\link[dtwSat]{twdtwAssessment}} and \code{\link[dtwSat]{twdtwAssess}}
}
\author{
Victor Maus, \email{vwmaus1@gmail.com}
}
