% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lb-improved.R
\name{lb_improved}
\alias{lb_improved}
\title{Lemire's improved DTW lower bound}
\usage{
lb_improved(x, y, window.size = NULL, norm = "L1", lower.env = NULL,
  upper.env = NULL)
}
\arguments{
\item{x}{A time series.}

\item{y}{A time series with the same length as \code{x}.}

\item{window.size}{Window size for envelope calculation. See details.}

\item{norm}{Pointwise distance. Either \code{L1} for Manhattan distance or \code{L2} for Euclidean.}

\item{lower.env}{Optionally, a pre-computed lower envelope for \strong{\code{y}} can be provided.}

\item{upper.env}{Optionally, a pre-computed upper envelope for \strong{\code{y}} can be provided.}
}
\value{
The improved lower bound for the DTW distance.
}
\description{
This function calculates a lower bound (LB) on the Dynamic Time Warp (DTW) distance between two time
series. It uses a Sakoe-Chiba constraint.
}
\details{
The lower bound is defined for time series of equal length only.

The windowing constraint uses a centered window. The calculations expect a value in \code{window.size}
that represents the distance between the point considered and one of the edges of the window. Therefore,
if, for example, \code{window.size = 10}, the warping for an observation \eqn{x_i} considers the points
between \eqn{x_{i-10}} and \eqn{x_{i+10}}, resulting in \code{10*2 + 1 = 21} observations falling within
the window.
}
\note{
If you wish to calculate the lower bound between several time series, it would be better to use the version
registered with the 'proxy' package, since it includes some small optimizations. See the examples.
}
\examples{

# Sample data
data(uciCT)

# Lower bound distance between two series
d.lbi <- lb_improved(CharTraj[[1]], CharTraj[[2]], window.size = 20)

# Corresponding true DTW distance
d.dtw <- dtw(CharTraj[[1]], CharTraj[[2]],
             window.type = "slantedband", window.size = 20)$distance

d.lbi <= d.dtw

# Calculating the LB between several time series using the 'proxy' package
# (notice how both argments must be lists)
D.lbi <- proxy::dist(CharTraj[1], CharTraj[2:5], method = "LB_Improved",
                     window.size = 20, norm = "L2")

# Corresponding true DTW distance
# (see dtwclust-package description for an explanation of DTW2)
D.dtw <- proxy::dist(CharTraj[1], CharTraj[2:5], method = "DTW2",
                     window.type = "slantedband", window.size = 20)

D.lbi <= D.dtw

}
\references{
Lemire D (2009). ``Faster retrieval with a two-pass dynamic-time-warping lower bound .'' \emph{Pattern Recognition}, \strong{42}(9), pp.
2169 - 2180. ISSN 0031-3203, \url{http://dx.doi.org/10.1016/j.patcog.2008.11.030}, \url{
http://www.sciencedirect.com/science/article/pii/S0031320308004925}.
}

