% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CENTROIDS-sdtw-cent.R
\name{sdtw_cent}
\alias{sdtw_cent}
\title{Centroid calculation based on soft-DTW}
\usage{
sdtw_cent(series, centroid = NULL, gamma = 0.01, weights = rep(1,
  length(series)), ..., opts = list(algorithm = "NLOPT_LD_LBFGS", maxeval =
  20L), error.check = TRUE)
}
\arguments{
\item{series}{A matrix or data frame where each row is a time series, or a list where each
element is a time series. Multivariate series should be provided as a list of matrices where
time spans the rows and the variables span the columns of each matrix.}

\item{centroid}{Optionally, a time series to use as reference. Defaults to a random series of
\code{series} if \code{NULL}. For multivariate series, this should be a matrix with the same
characteristics as the matrices in \code{series}.}

\item{gamma}{Positive regularization parameter, with lower values resulting in less smoothing.}

\item{weights}{A vector of weights for each element of \code{series}.}

\item{...}{Further arguments for \code{\link[nloptr:nloptr]{nloptr::nloptr()}} (except \code{opts} and \code{...}).}

\item{opts}{List of options to pass to \code{\link[nloptr:nloptr]{nloptr::nloptr()}}.}

\item{error.check}{Logical indicating whether the function should try to detect inconsistencies
and give more informative errors messages. Also used internally to avoid repeating checks.}
}
\value{
The resulting centroid, with attribute \code{nloptr_results} specifying the optimization
results (except for \code{solution}, which is the returned centroid).
}
\description{
Soft-DTW centroid function as proposed in Cuturi and Blondel (2017).
}
\details{
Note that you can trace the optimization by specifing \code{print_level > 0} in \code{opts}.
}
\section{Parallel Computing}{


  Please note that running tasks in parallel does \strong{not} guarantee faster computations. The
  overhead introduced is sometimes too large, and it's better to run tasks sequentially.

  This function uses the \code{\link[RcppParallel:RcppParallel-package]{RcppParallel}} package
  for parallelization. It uses all available threads by default (see
  \code{\link[RcppParallel:defaultNumThreads]{RcppParallel::defaultNumThreads()}}), but this can
  be changed by the user with
  \code{\link[RcppParallel:setThreadOptions]{RcppParallel::setThreadOptions()}}.

  An exception to the above is when this function is called within a
  \code{\link[foreach:foreach]{foreach}} parallel loop \strong{made by dtwclust}. If the parallel
  workers do not have the number of threads explicitly specified, this function will default to 1
  thread per worker. See the parallelization vignette for more information
  (\code{browseVignettes("dtwclust")}).



For unknown reasons, this function has returned different results (in the order of 1e-6) when
using multi-threading in x64 Windows installations in comparison to other environments (using
nloptr v1.0.4). Consider limiting the number of threads if you run into reproducibility
problems.
}

\references{
Cuturi, M., & Blondel, M. (2017). Soft-DTW: a Differentiable Loss Function for Time-Series. arXiv
preprint arXiv:1703.01541.
}
