% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d.spls.predict.R
\name{d.spls.predict}
\alias{d.spls.predict}
\title{Makes predictions from a fitted Dual-SPLS model}
\usage{
d.spls.predict(mod.dspls,X,liste_cp)
}
\arguments{
\item{mod.dspls}{a fitted Dual-SPLS object.}

\item{X}{a numeric matrix of predictors values. Each row represents an observation and each column a predictor variable.}

\item{liste_cp}{a numeric vector of the components for which prediction is required.}
}
\value{
Vector or matrix of estimated responses.
}
\description{
The function \code{d.spls} makes predictions from a fitted Dual-SPLS model.
}
\details{
The coefficients computed in the Dual-SPLS object are used to predict the fitted response values of new matrix \code{X}.
Users can choose how many Dual-SPLS components should be used.
}
\examples{
### load dual.spls library
library(dual.spls)
### parameters
n <- 100
p <- 50
nondes <- 20
sigmaondes <- 0.5
data=d.spls.simulate(n=n,p=p,nondes=nondes,sigmaondes=sigmaondes)

X <- data$X
y <- data$y

pcal <- 70
ncells <- 3

split <- d.spls.calval(X=X,pcal=pcal,y=y,ncells=ncells)

indcal= split$indcal
indval= split$indval

Xcal=X[indcal,]
Xval=X[indval,]
ycal=y[indcal]
yval=y[indval]

#fitting the model
ncp=10
mod.dspls <- d.spls.lasso(X=Xcal,y=ycal,ncp=ncp,ppnu=0.9,verbose=TRUE)

ycalhat=mod.dspls$fitted.values
rescal=mod.dspls$residuals
# predictions on validation
yvalhat=d.spls.predict(mod.dspls,Xval, liste_cp=1:ncp)

#Computing RMSE error
RMSEcal.dspls=apply(rescal,2,function(u) sqrt(mean(u^2)) )
RMSEval.dspls=apply(yvalhat,2,function(u) sqrt(mean((yval-u)^2)) )



}
\author{
François Wahl Louna Alsouki
}
