% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Logic.R
\docType{methods}
\name{Logic}
\alias{Logic}
\alias{==}
\alias{==,dual,numeric-method}
\alias{==,numeric,dual-method}
\alias{==,dual,dual-method}
\alias{!=}
\alias{!=,dual,numeric-method}
\alias{!=,numeric,dual-method}
\alias{!=,dual,dual-method}
\alias{>}
\alias{>,dual,numeric-method}
\alias{>,numeric,dual-method}
\alias{>,dual,dual-method}
\alias{>=}
\alias{>=,dual,numeric-method}
\alias{>=,numeric,dual-method}
\alias{>=,dual,dual-method}
\alias{<}
\alias{<,dual,numeric-method}
\alias{<,numeric,dual-method}
\alias{<,dual,dual-method}
\alias{<=}
\alias{<=,dual,numeric-method}
\alias{<=,numeric,dual-method}
\alias{<=,dual,dual-method}
\title{Logic Operators for Comparing Dual Numbers}
\usage{
\S4method{==}{dual,numeric}(e1, e2)

\S4method{==}{numeric,dual}(e1, e2)

\S4method{==}{dual,dual}(e1, e2)

\S4method{!=}{dual,numeric}(e1, e2)

\S4method{!=}{numeric,dual}(e1, e2)

\S4method{!=}{dual,dual}(e1, e2)

\S4method{>}{dual,numeric}(e1, e2)

\S4method{>}{numeric,dual}(e1, e2)

\S4method{>}{dual,dual}(e1, e2)

\S4method{>=}{dual,numeric}(e1, e2)

\S4method{>=}{numeric,dual}(e1, e2)

\S4method{>=}{dual,dual}(e1, e2)

\S4method{<}{dual,numeric}(e1, e2)

\S4method{<}{numeric,dual}(e1, e2)

\S4method{<}{dual,dual}(e1, e2)

\S4method{<=}{dual,numeric}(e1, e2)

\S4method{<=}{numeric,dual}(e1, e2)

\S4method{<=}{dual,dual}(e1, e2)
}
\arguments{
\item{e1}{dual object or numeric value.}

\item{e2}{dual object or numeric value.}
}
\value{
The correspondent boolean/logical value of the comparison between
\code{e1} and \code{e2} is returned.
}
\description{
These functions provide the operators for logical comparisons between dual 
numbers.  These operators are designed to test equality and 
inequalities (such as "not equal", "greater", "less", "greater or equal", 
"less or equal").
}
\examples{
x <- dual(1.5, 1:0)
y <- dual(2.6, 0:1)
x == y
x != y
x > y
x >= y
x < y
x <= y
}
