% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotfunctions.R
\name{uvplot}
\alias{uvplot}
\title{plot centre as vectors}
\usage{
uvplot(uv, z = NULL, x = NULL, y = NULL, col = "green",
  zcol = grDevices::gray.colors(32, 0, 1), n = 42, f = 1,
  length = 0.05, ...)
}
\arguments{
\item{uv}{an array of dimension \code{ nx x ny x 2 }, containing the u- and v-component, result of \code{cen2uv}}

\item{z}{image to show in the background, defaults to \code{sqrt(x^2+y^2)}}

\item{x, y}{optional x- and y-coordinates for the plot, must match the dimensions of \code{z}}

\item{col}{color of the arrows}

\item{zcol}{color scale for the image}

\item{n}{number of arrows in one direction}

\item{f}{factor by which to enlarge the arrows}

\item{length}{length of the arrowhead in inches}

\item{...}{further arguments passed to \code{image}}
}
\description{
display the radial and angular component of the spectrum's centre as arrows.
}
\details{
The pivot of the arrows is at the location to which the u- and v-component belong. No arrowhead is displayed since the egdges detcted by the cdtwt have an orientation but no sign. The default size of the arrows is such that a 'velocity' of 1 corresponds to 5\% of the shorter image side.
}
\examples{
uv <- cen2uv( dt2cen( fld2dt( blossom ) ) )
uvplot( uv, z=blossom )
}
\seealso{
\code{\link{cen2uv}}
}
