% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Driver.R
\name{dbConnect,duckdb_driver-method}
\alias{dbConnect,duckdb_driver-method}
\alias{dbDisconnect,duckdb_connection-method}
\alias{duckdb}
\alias{duckdb_shutdown}
\title{Connect to a DuckDB database instance}
\usage{
\S4method{dbConnect}{duckdb_driver}(
  drv,
  dbdir = DBDIR_MEMORY,
  ...,
  debug = getOption("duckdb.debug", FALSE),
  read_only = FALSE
)

\S4method{dbDisconnect}{duckdb_connection}(conn, ..., shutdown = FALSE)

duckdb(dbdir = DBDIR_MEMORY, read_only = FALSE)

duckdb_shutdown(drv)
}
\arguments{
\item{drv}{Object returned by \code{duckdb()}}

\item{dbdir}{Location for database files. Should be a path to an existing
directory in the file system. With the default, all
data is kept in RAM}

\item{...}{Ignored}

\item{debug}{Print additional debug information such as queries}

\item{read_only}{Set to \code{TRUE} for read-only operation}

\item{conn}{A \code{duckdb_connection} object}

\item{shutdown}{Set to \code{TRUE} to shut down the DuckDB database instance that this connection refers to.}
}
\value{
\code{dbConnect()} returns an object of class
\linkS4class{duckdb_connection}.

\code{duckdb()} returns an object of class \linkS4class{duckdb_driver}.

\code{dbDisconnect()} and \code{duckdb_shutdown()} are called for their
side effect.
}
\description{
\code{dbConnect()} connects to a database instance.

\code{dbDisconnect()} closes a DuckDB database connection, optionally shutting down
the associated instance.

\code{duckdb()} creates or reuses a database instance.

\code{duckdb_shutdown()} shuts down a database instance.
}
\examples{
drv <- duckdb()
con <- dbConnect(drv)

dbGetQuery(con, "SELECT 'Hello, world!'")

dbDisconnect(con)
duckdb_shutdown(drv)

# Shorter:
con <- dbConnect(duckdb())
dbGetQuery(con, "SELECT 'Hello, world!'")
dbDisconnect(con, shutdown = TRUE)
}
