% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{planecrash}
\alias{planecrash}
\title{DVI dataset: Simulated plane crash}
\format{
A \code{dviData} object with the following content:
\itemize{
\item \code{pm}: A list of 8 female singletons (victims).
\item \code{am}: A list of 5 pedigrees, each with one missing member and one
genotyped member.
\item \code{missing}: A vector containing the names of the missing persons.
}
}
\usage{
planecrash
}
\description{
A simulated dataset based on Exercise 3.3 in Egeland et al. "Relationship
Inference with Familias and R" (2015).
}
\details{
The 15 markers are \code{CSF1PO}, \code{D13S317}, \code{D16S539}, \code{D18S51}, \code{D21S11},
\code{D3S1358}, \code{D5S818}, \code{D7S820}, \code{D8S1179}, \code{FGA}, \code{PENTA_D}, \code{PENTA_E},
\code{TH01},  \code{TPOX},   and  \code{VWA}.

Source code for the simulation, and a file containing the allele frequencies,
can be found in the \code{data-raw} folder of the GitHub repository:
https://github.com/thoree/dvir.
}
\examples{
planecrash

# plotDVI(planecrash)

# Markers and allele frequencies
db = pedtools::getFreqDatabase(planecrash$pm)
db 

}
\keyword{datasets}
