% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/append_to_stream.R
\name{append_data_frame_to_stream}
\alias{append_data_frame_to_stream}
\title{Append an R data frame to a data.world stream.}
\usage{
append_data_frame_to_stream(owner_id, dataset_id, stream_id, data_frame,
  retry_times = 3, retry_quiet = FALSE)
}
\arguments{
\item{owner_id}{User name and unique identifier of the creator of a
dataset or project}

\item{dataset_id}{Dataset unique identifier}

\item{stream_id}{Stream unique identifier as defined by the user the first
time the stream was used. Only lower case letters, numbers and
dashes are allowed.}

\item{data_frame}{The data frame containing the rows to append to the
stream}

\item{retry_times}{the number of times to retry the request}

\item{retry_quiet}{whether to suppress diagnostic messages during retries}
}
\value{
Server response message.
}
\description{
Append an R data frame to a data.world stream.
If the data.world API
returns an HTTP status of 429 (Too Many Requests), this function uses
\code{\link[httr]{RETRY}} to retry the request.
}
\examples{
\dontrun{
  aDf <- data.frame(ID=1:2, Value=c('One', 'Two'), stringsAsFactors = FALSE)
  dwapi::append_data_frame_to_stream(owner_id = 'user',
    dataset_id = 'dataset', stream_id = 'mystream',
    aDf)
  aDf <- data.frame(ID=1:2, Value=c('One', 'Two'), stringsAsFactors = FALSE)
  dwapi::append_data_frame_to_stream(owner_id = 'user',
    dataset_id = 'dataset', stream_id = 'mystream',
    aDf, retry_times = 10, retry_quiet = TRUE)
}
}
