% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fun_Contour-plot_sim.R
\name{plot_cont}
\alias{plot_cont}
\title{Contour plot of a variable simulation, with observed data shown as dots in the generated contour plot.}
\usage{
plot_cont(
  sim = temp.interpolated,
  sim.start = "2017-06-06",
  sim.end = "2017-06-15",
  legend.title = "T °C",
  min.depth = 0,
  max.depth = 13,
  by.value = 0.5,
  nlevels = 20,
  plot.save = TRUE,
  file_name = "Contour_temp.png",
  height = 5,
  width = 8,
  ppi = 150
)
}
\arguments{
\item{sim}{a matrix of simulated variables that have been interpolated}

\item{sim.start, sim.end}{the start and end of the simulation period for the DYRESM-CAEDYM model run of interest. The date format must be "\%Y-\%m-\%d".}

\item{legend.title}{the legend title of the contour figure.}

\item{min.depth, max.depth, by.value}{minimum and maximum depth used to be the start of y axis of the contour plot, at the increment of by.value.}

\item{nlevels}{a set of levels which are used to partition the range of simulation variable.}

\item{plot.save}{if TRUE, the plot is saved with the "height","width", and "ppi" parameters.}

\item{file_name}{the file path to save the generated contour figure.}

\item{height, width}{the relative height/width of the figure.}

\item{ppi}{the ppi value of the figure.}
}
\value{
a graph file of contour plot saved in the Figure folder.
}
\description{
Contour plot a matrix of a bio-geochemical variable values, which can be generated through "interpol" function.
}
\examples{
 # extract simulated temperature values from DYRESM-CAEDYM simulation file
 var.values<-ext.output(dycd.output=system.file("extdata", "dysim.nc", package = "dycdtools"),
                       var.extract=c("TEMP"))

 for(i in 1:length(var.values)){
  expres<-paste0(names(var.values)[i],"<-data.frame(var.values[[",i,"]])")
  eval(parse(text=expres))
 }

# interpolate temperature for depths from 0 to 13 m at increment of 0.5 m
  temp.interpolated<-interpol(layerHeights = dyresmLAYER_HTS_Var,
                             var = dyresmTEMPTURE_Var,
                             min.dept = 0,max.dept = 13,by.value = 0.5)

# contour plot of temperature simulations
  plot_cont(sim=temp.interpolated,
            sim.start="2017-06-06",
            sim.end="2017-06-15",
            legend.title="T \u00B0C",
            min.depth=0,max.depth=13,by.value=0.5,
            nlevels=20,
            plot.save=FALSE,
            file_name="Contour_temp.png",
            height=5,width=8,ppi=150)

}
