% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/event.R
\name{dyEvent}
\alias{dyEvent}
\title{dygraph event line}
\usage{
dyEvent(dygraph, x, label = NULL, labelLoc = c("top", "bottom"),
  color = "black", strokePattern = "dashed", date)
}
\arguments{
\item{dygraph}{Dygraph to add event line to}

\item{x}{Either numeric or date/time for the event, depending on the format
of the x-axis of the dygraph. (For date/time must be a \code{POSIXct}
object or another object convertible to \code{POSIXct} via
\code{as.POSIXct})}

\item{label}{Label for event. Defaults to blank.}

\item{labelLoc}{Location for label (top or bottom)}

\item{color}{Color of event line. This can be of the form "#AABBCC" or 
"rgb(255,100,200)" or "yellow". Defaults to black.}

\item{strokePattern}{A predefined stroke pattern type ("dotted", "dashed",
"dotdash", or "solid") or a custom pattern array where the even index is 
a draw and odd is a space in pixels. Defaults to dashed.}

\item{date}{(deprecated) See argument \code{x}.}
}
\value{
A dygraph with the specified event line.
}
\description{
Add a vertical event line to a dygraph
}
\note{
See the \href{http://rstudio.github.io/dygraphs/gallery-event-lines.html}{online 
  documentation} for additional details and examples.
}
\examples{
library(dygraphs)

dygraph(presidents, main = "Presidential Approval") \%>\%
  dyAxis("y", valueRange = c(0, 100)) \%>\%
  dyEvent("1950-6-30", "Korea", labelLoc = "bottom") \%>\%
  dyEvent("1965-2-09", "Vietnam", labelLoc = "bottom")
dygraph(presidents, main = "Presidential Approval") \%>\%
  dyAxis("y", valueRange = c(0, 100)) \%>\%
  dyEvent(c("1950-6-30", "1965-2-09"), c("Korea", "Vietnam"), labelLoc = "bottom") 
 
}

