/*
 * Decompiled with CFR 0.152.
 */
package contrib.ch.randelshofer.quaqua.colorchooser;

import contrib.ch.randelshofer.quaqua.QuaquaUtilities;
import contrib.ch.randelshofer.quaqua.colorchooser.DefaultPalettes;
import contrib.ch.randelshofer.quaqua.util.ResourceBundleUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class Crayons
extends JPanel {
    private ResourceBundleUtil labels = (ResourceBundleUtil)UIManager.get("Labels");
    private Image crayonsImage;
    private static final int[] crayonXPoints = new int[]{10, 12, 20, 22, 22, 0, 0, 2};
    private static final int[] crayonYPoints = new int[]{0, 0, 21, 21, 104, 104, 21, 21};
    private Color color = Color.white;
    private Crayon selectedCrayon = null;
    private MouseHandler mouseHandler;
    private Crayon[] crayons;

    public Crayons() {
        this.initComponents();
        this.setForeground(new Color(0x808080));
        this.setPreferredSize(new Dimension(195, 208));
        this.setFont(UIManager.getFont("ColorChooser.crayonsFont"));
        this.crayonsImage = this.createCrayonsImage();
        this.crayons = this.createCrayons();
        this.mouseHandler = new MouseHandler();
        this.addMouseListener(this.mouseHandler);
    }

    protected Image createCrayonsImage() {
        return (Image)UIManager.get("ColorChooser.crayonsImage");
    }

    protected Crayon[] createCrayons() {
        Color[] colors = DefaultPalettes.CRAYONS;
        this.crayons = new Crayon[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            this.crayons[i] = new Crayon(colors[i], this.labels.getString("ColorChooser.crayon." + Integer.toHexString(0xFF000000 | colors[i].getRGB()).substring(2)), new Polygon((int[])crayonXPoints.clone(), (int[])crayonYPoints.clone(), crayonXPoints.length));
            this.crayons[i].shape.translate(i % 8 * 22 + 4 + i / 8 % 2 * 11, i / 8 * 20 + 23);
        }
        return this.crayons;
    }

    public void setColor(Color newValue) {
        Color oldValue = this.color;
        this.color = newValue;
        Crayon newSelectedCrayon = null;
        int newRGB = newValue.getRGB() & 0xFFFFFF;
        for (int i = 0; i < this.crayons.length; ++i) {
            if ((this.crayons[i].color.getRGB() & 0xFFFFFF) != newRGB) continue;
            newSelectedCrayon = this.crayons[i];
        }
        if (newSelectedCrayon != this.selectedCrayon) {
            this.selectedCrayon = newSelectedCrayon;
            this.repaint();
        }
        this.firePropertyChange("Color", oldValue, newValue);
    }

    public Color getColor() {
        return this.color;
    }

    public void paintComponent(Graphics gr) {
        Graphics2D g = (Graphics2D)gr;
        Object oldHints = QuaquaUtilities.beginGraphics(g);
        g.drawImage(this.crayonsImage, 0, 0, this);
        if (this.selectedCrayon != null) {
            g.setColor(this.getForeground());
            FontMetrics fm = g.getFontMetrics();
            int nameWidth = fm.stringWidth(this.selectedCrayon.name);
            g.drawString(this.selectedCrayon.name, (this.crayonsImage.getWidth(this) - nameWidth) / 2, fm.getAscent() + 1);
        }
        QuaquaUtilities.endGraphics(g, oldHints);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        public void mousePressed(MouseEvent evt) {
            int x = evt.getX();
            int y = evt.getY();
            if (x > 0 && x < Crayons.this.crayonsImage.getWidth(Crayons.this) && y > 0 && y < Crayons.this.crayonsImage.getHeight(Crayons.this)) {
                for (int i = Crayons.this.crayons.length - 1; i >= 0; --i) {
                    if (!((Crayons)Crayons.this).crayons[i].shape.contains(x, y)) continue;
                    Crayons.this.setColor(((Crayons)Crayons.this).crayons[i].color);
                    break;
                }
            }
        }
    }

    private class Crayon {
        Polygon shape;
        Color color;
        String name;

        public Crayon(Color color, String name, Polygon shape) {
            this.color = color;
            this.name = name;
            this.shape = shape;
        }
    }
}

