/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.test;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import org.freehep.graphics2d.PrintColor;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsio.test.TestingPanel;

public class TestPrintColors
extends TestingPanel {
    public TestPrintColors(String[] args) throws Exception {
        super(args);
        this.setLayout(new BorderLayout());
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, Color.white), BorderFactory.createMatteBorder(2, 2, 2, 2, Color.black));
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(14, 3));
        JLabel label1 = new JLabel("Color");
        panel.add(label1);
        JLabel label2 = new JLabel("GrayScale");
        panel.add(label2);
        JLabel label3 = new JLabel("Black and White");
        panel.add(label3);
        for (int i = 0; i < 13; ++i) {
            TestColor test = new TestColor(0, i);
            test.setBorder(border);
            panel.add(test);
            test = new TestColor(1, i);
            test.setBorder(border);
            panel.add(test);
            test = new TestColor(2, i);
            test.setBorder(border);
            panel.add(test);
        }
        this.add((Component)panel, "Center");
    }

    public static void main(String[] args) throws Exception {
        new TestPrintColors(args).runTest();
    }

    class TestColor
    extends JPanel {
        private int mode;
        private int bkgColorIndex;

        public TestColor(int mode, int bkgColorIndex) {
            this.mode = mode;
            this.bkgColorIndex = bkgColorIndex;
        }

        public void paintComponent(Graphics g) {
            Dimension dim = this.getSize();
            Insets insets = this.getInsets();
            Color bkgColor = PrintColor.getDefaultColor((int)this.bkgColorIndex);
            VectorGraphics vg = VectorGraphics.create((Graphics)g);
            vg.setColorMode(this.mode);
            vg.setColor(bkgColor);
            vg.fillRect(insets.left, insets.top, dim.width - insets.left - insets.right, dim.height - insets.top - insets.bottom);
        }
    }
}

