% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatiotemp_resolution.R
\name{spatiotemp_resolution}
\alias{spatiotemp_resolution}
\title{Filter species occurrence records by given spatial and temporal resolution}
\usage{
spatiotemp_resolution(occ.data, spatial.res, temporal.res)
}
\arguments{
\item{occ.data}{a data frame, with columns for occurrence record co-ordinates and dates with
column names as follows; record longitude as "x", latitude as "y", year as "year", month as
"month", and day as "day".}

\item{spatial.res}{optional; a numeric value, the minimum acceptable number of decimal places
given for occurrence record co-ordinates.}

\item{temporal.res}{optional; a character string, the minimum acceptable temporal resolution of
occurrence record dates. One of \code{day} , \code{month} or \code{year}: can be abbreviated.}
}
\value{
Returns a data frame of species records filtered by the minimum acceptable spatial
resolution of co-ordinates and temporal resolution of dates.
}
\description{
Filters species occurrence record data frame to exclude records with co-ordinates and dates that
do not meet specified spatial and temporal resolution.
}
\details{
Excludes species occurrence records that do not meet the minimum spatial and temporal
resolution specified.

If \code{spatial.res} given, the value of 1 represents an acceptable co-ordinate resolution of one
decimal place, roughly equal to 11.1km, and value of 3 represents three decimal places, roughly
equal to 111m.

If \code{temporal.res} given, \code{temporal.res = day} would result in exclusion of records without
values for year, month and day, and \code{temporal.res = year} would only exclude records without
values for year.

\code{spatial.res} and \code{temporal.res} can be informed based upon the highest spatial and temporal
resolution of the datasets to be utilised when extracting dynamic variables.

For example, if explanatory variables datasets are annual, then a \code{temporal.res} of \code{year} is
adequate, whereas if datasets are daily, then \code{temporal.res} of \code{day} may be more appropriate.
}
\examples{
data(sample_occ_data)
sample_occ_data <- convert_gbif(sample_occ_data)

spatial_res_high <- spatiotemp_resolution(sample_occ_data, spatial.res = 4)

spatial_res_low <- spatiotemp_resolution(sample_occ_data, spatial.res = 1)

temporal_res <- spatiotemp_resolution(sample_occ_data, temporal.res = "day")
}
