% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddhazard.R
\name{ddhazard}
\alias{ddhazard}
\title{Function to fit dynamic discrete hazard models}
\usage{
ddhazard(formula, data, model = "logit", by, max_T, id, a_0, Q_0, Q = Q_0,
  order = 1, weights, control = list(), verbose = F)
}
\arguments{
\item{formula}{\code{\link[survival]{coxph}} like formula with \code{\link[survival]{Surv}(tstart, tstop, event)} on the left hand site of \code{~}}

\item{data}{Data frame or environment containing the outcome and co-variates}

\item{model}{\code{"logit"}, \code{"exp_clip_time_w_jump"}, \code{"exp_clip_time"}, \code{"exp_bin"} or \code{"exp_combined"} for the discrete time function using the logistic link function in the first case or for the continuous time model with different estimation method in the four latter cases (see the ddhazard for details on the methods)}

\item{by}{Interval length of the bins in which parameters are fixed}

\item{max_T}{End of the last interval. The last stop time with an event is selected if the parameter is omitted}

\item{id}{Vector of ids for each row of the in the design matrix}

\item{a_0}{Vector \eqn{a_0} for the initial coefficient vector for the first iteration (optional). Default is estimates from static model (see \code{\link{static_glm}})}

\item{Q_0}{Covariance matrix for the prior distribution}

\item{Q}{Initial covariance matrix for the state equation}

\item{order}{Order of the random walk}

\item{weights}{Weights to use if e.g. a skewed sample is used}

\item{control}{List of control variables (see details below)}

\item{verbose}{\code{TRUE} if you want status messages during execution}
}
\value{
A list with class \code{fahrmeier_94}. The list contains:
\describe{
\item{\code{formula}}{The passed formula }
\item{\code{state_vecs}}{2D matrix with the estimated state vectors (regression parameters) in each bin }
\item{\code{state_vars}}{3D array with smoothed variance estimates for each state vector }
\item{\code{lag_one_cov}}{3D array with lagged correlation matrix for each for each change in the state vector. Only present when the model is logit and the method is EKF }
\item{\code{n_risk}}{The number of observations in each interval }
\item{\code{times}}{The interval borders }
\item{\code{risk_set}}{The object from \code{\link{get_risk_obj}} if saved }
\item{\code{data}}{The \code{data} argument if saved }
\item{\code{id}}{ids used to match rows in \code{data} to individuals }
\item{\code{order}}{Order of the random walk }
\item{\code{F_}}{Matrix with that map transition from one state vector to the next }
\item{\code{method}}{Method used in the E-step }
\item{\code{est_Q_0}}{\code{TRUE} if \code{Q_0} was estimated in the EM-algorithm }
\item{\code{hazard_func}}{Hazard function }
\item{\code{hazard_first_deriv}}{First derivative of the hazard function with respect to the linear predictor}
}
}
\description{
Function to fit dynamic discrete hazard models using state space models
}
\details{
This function can be used to estimate a binary regression where the regression parameters follows a given order random walk. The order is specified by the \code{order} argument. 1. and 2. order random walks is implemented. The regression parameters are updated at time \code{by}, 2\code{by}, ..., \code{max_T}. See the vignette 'ddhazard' for more details

The Extended Kalman filter or Unscented Kalman filter needs an initial co-variance matrix \code{Q_0} and state vector \code{a_0}. An estimate from a time-invariant model is provided for \code{a_0} if it is not supplied (the same model you would get from \code{\link{static_glm}} function). A diagonal matrix with large entries is recommended for \code{Q_0}. What is large dependents on the data set and \code{model}. Further, a variance matrix for the first iteration \code{Q} is needed. It is recommended to select diagonal matrix with low values for the latter. The \code{Q}, \code{a_0} and optionally \code{Q_0} is estimated with an EM-algorithm

The model is specified through the \code{model} argument. Currently, \code{'logit'} and \code{'exponential'} is available. The former uses an logistic model where outcomes are binned into the intervals. Be aware that there can be loss of information due to binning. It is key for the logit model that the \code{id} argument is provided if individuals in the data set have time varying co-variates. The latter model uses an exponential model for the arrival times where there is no loss information due to binning

It is recommended to see the Shiny app demo for this function by calling \code{\link{ddhazard_app}()}
}
\section{Control}{

The \code{control} argument allows you to pass a \code{list} to select additional parameters. See the vignette 'ddhazard' for more information on hyper parameters. Unspecified elements of the list will yield default values
\describe{
\item{\code{method}}{Set to the method to use in the E-step. Either \code{"EKF"} for the Extended Kalman Filter or \code{"UKF"}for the Unscented Kalman Filter. \code{"EKF"} is the default}
\item{\code{LR}}{Learning rate for the Extended Kalman filter}
\item{\code{NR_eps}}{Tolerance for the Extended Kalman filter. Default is \code{NULL} which means that no extra iteration is made in the correction step}
\item{\code{alpha}}{Hyper parameter \eqn{\alpha} in the Unscented Kalman Filter}
\item{\code{beta}}{Hyper parameter \eqn{\beta} in the Unscented Kalman Filter }
\item{\code{kappa}}{Hyper parameter \eqn{\kappa} in the Unscented Kalman Filter}
\item{\code{n_max}}{Maximum number of iteration in the EM-algorithm}
\item{\code{eps}}{Tolerance parameter for the EM-algorithm}
\item{\code{est_Q_0}}{\code{TRUE} if you want the EM-algorithm to estimate \code{Q_0}. Default is \code{FALSE}}
\item{\code{save_risk_set}}{\code{TRUE} if you want to save the list from \code{\link{get_risk_obj}} used to estimate the model. It may be needed for later call to \code{residuals}, \code{plot} and \code{logLike}. Can be set to \code{FALSE} to save memory}
\item{\code{save_data}}{\code{TRUE} if you want to save the list \code{data} argument. It may be needed for later call to \code{residuals}, \code{plot} and \code{logLike}. Can be set to \code{FALSE} to save memory}
\item{\code{ridge_eps}}{Penalty term added to the diagonal of the covariance matrix of the observational equation in either the EKF or UKF}
\item{\code{fixed_terms_method}}{The method used to estimate the fixed effects. Either \code{'M_step'} or \code{'E_step'} for estimation in the M-step or E-step respectively}
\item{\code{Q_0_term_for_fixed_E_step}}{The diagonal value of the initial covariance matrix, \code{Q_0}, for the fixed effects if fixed effects are estimated in the E-step}
\item{\code{eps_fixed_parems}}{Tolerance used in the M-step of the Fisher's Scoring Algorithm for the fixed effects}
}
}
\references{
Fahrmeir, Ludwig. \emph{Dynamic modelling and penalized likelihood estimation for discrete time survival data}. Biometrika 81.2 (1994): 317-330.

Durbin, James, and Siem Jan Koopman. \emph{Time series analysis by state space methods}. No. 38. Oxford University Press, 2012.
}
\seealso{
\code{\link[=plot.fahrmeier_94]{plot}}, \code{\link[=residuals.fahrmeier_94]{residuals}}, \code{\link[=predict.fahrmeier_94]{predict}}, \code{\link{static_glm}}, \code{\link{ddhazard_app}}, \code{\link{ddhazard_boot}}
}

