% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.PF_clouds}
\alias{plot.PF_clouds}
\title{Plot of Clouds from a PF_clouds Object}
\usage{
\method{plot}{PF_clouds}(x, y, type = c("smoothed_clouds",
  "forward_clouds", "backward_clouds"), ylim, add = FALSE,
  qlvls = c(0.05, 0.5, 0.95), pch = 4, lty = 1, col, ..., cov_index,
  qtype = c("points", "lines"))
}
\arguments{
\item{x}{an object of class \code{PF_clouds}.}

\item{y}{unused.}

\item{type}{parameter to specify which cloud to plot.}

\item{ylim}{\code{ylim} passed to \code{\link{matplot}}.}

\item{add}{\code{TRUE} if a new plot should not be made.}

\item{qlvls}{vector of quantile levels to be plotted.}

\item{pch}{\code{pch} argument for the quantile points.}

\item{lty}{\code{lty} argument for the mean curves.}

\item{col}{\code{col} argument to \code{\link{matplot}} and
\code{\link{matpoints}} or \code{\link{matlines}}.}

\item{...}{unused.}

\item{cov_index}{indices of the state vector to plot. All are plotted if
this argument is omitted.}

\item{qtype}{character specifying how to show quantiles. Either
\code{"points"} for crosses or \code{"lines"} for dashed lines.}
}
\value{
List with quantile levels and mean curve.
}
\description{
Plots mean curve along with quantiles through time for the forward, backward or smoothed clouds.
}
