% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_gets.R
\name{get_code}
\alias{get_code}
\alias{get_code.dynamiteformula}
\alias{get_code.dynamitefit}
\title{Extract the Stan Code of the Dynamite Model}
\usage{
get_code(x, ...)

\method{get_code}{dynamiteformula}(x, data, time, group = NULL, blocks = NULL, ...)

\method{get_code}{dynamitefit}(x, blocks = NULL, ...)
}
\arguments{
\item{x}{[\code{dynamiteformula} or \code{dynamitefit}]\cr The model formula or an
existing \code{dynamitefit} object. See \code{\link[=dynamiteformula]{dynamiteformula()}} and \code{\link[=dynamite]{dynamite()}}.}

\item{...}{Ignored.}

\item{data}{[\code{data.frame}, \code{tibble::tibble}, or \code{data.table::data.table}]\cr
The data that contains the variables in the
model. Supported column types are \code{integer}, \code{logical}, \code{double}, and
\code{factor}. Columns of type \code{character} will be converted to factors.
Unused factor levels will be dropped. The \code{data} can contain missing
values which will simply be ignored in the estimation in a case-wise
fashion (per time-point and per channel). Input \code{data} is converted to
channel specific matrix representations via \code{\link[stats:model.matrix]{stats::model.matrix.lm()}}.}

\item{time}{[\code{character(1)}]\cr A column name of \code{data} that denotes the
time index of observations. If this variable is a factor, the integer
representation of its levels are used internally for defining the time
indexing.}

\item{group}{[\code{character(1)}]\cr A column name of \code{data} that denotes the
unique groups or \code{NULL} corresponding to a scenario without any groups.
If \code{group} is \code{NULL}, a new column \code{.group} is created with constant
value \code{1L} is created indicating that all observations belong to the same
group. In case of name conflicts with \code{data}, see the \code{group_var} element
of the return object to get the column name of the new variable.}

\item{blocks}{[\code{character()}]\cr Stan block names to extract. If \code{NULL},
extracts the full model code.}
}
\value{
The stan model blocks as a \code{character} string.
}
\description{
Returns the Stan code of the model. Mostly useful for debugging or for
building a customized version of the model.
}
\examples{
d <- data.frame(y = rnorm(10), x = 1:10, time = 1:10, id = 1)
cat(get_code(obs(y ~ x, family = "gaussian"),
  data = d, time = "time", group = "id"
))
# same as
cat(dynamite(obs(y ~ x, family = "gaussian"),
  data = d, time = "time", group = "id",
  debug = list(model_code = TRUE, no_compile = TRUE)
)$model_code)

}
