% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.R
\name{coef.dynamitefit}
\alias{coef.dynamitefit}
\title{Extract Regression Coefficients of a Dynamite Model}
\usage{
\method{coef}{dynamitefit}(
  object,
  parameters = NULL,
  type = c("beta", "delta", "nu", "lambda", "psi"),
  responses = NULL,
  summary = TRUE,
  probs = c(0.05, 0.95),
  include_alpha = TRUE,
  ...
)
}
\arguments{
\item{object}{[\code{dynamitefit}]\cr The model fit object.}

\item{parameters}{[\code{character()}]\cr Parameter(s) for which the samples
should be extracted. Possible options can be found with function
\code{get_parameter_names()}. Default is all parameters of specific type for all
responses.}

\item{type}{[\code{character(1)}]\cr Either \code{beta} (the default) for
time-invariant coefficients, \code{delta} for time-varying coefficients,
\code{nu} for random effects, \code{lambda} for factor loadings, or \code{psi} for
latent factor. Ignored if the argument \code{parameters} is supplied.}

\item{responses}{[\code{character()}]\cr Response(s) for which the samples
should be extracted. Possible options are elements of
\code{unique(x$priors$response)}, and the default is this entire vector.
Ignored if the argument \code{parameters} is supplied.}

\item{summary}{[\code{logical(1)}]\cr If \code{TRUE}, returns posterior
mean, standard deviation, and posterior quantiles (as defined by the
\code{probs} argument) for all parameters. If \code{FALSE} (default), returns the
posterior samples instead.}

\item{probs}{[\code{numeric()}]\cr Quantiles of interest. Default is
\code{c(0.05, 0.95)}.}

\item{include_alpha}{[\code{logical(1)}]\cr If \code{TRUE} (default), extracts also
time-invariant intercept term alpha if time-invariant parameters beta are
extracted, and time-varying alpha if time-varying delta are extracted.
Ignored if the argument \code{parameters} is supplied.
@param summary [\code{logical(1)}]\cr If \code{TRUE} (default), returns posterior
mean, standard deviation, and posterior quantiles (as defined by the
\code{probs} argument) for all parameters. If \code{FALSE}, returns the
posterior samples instead.}

\item{...}{Ignored.}
}
\value{
A \code{tibble} containing either samples or summary statistics of the
model parameters in a long format.
}
\description{
Extracts either time-varying or time-invariant parameters of the model.
}
\examples{
betas <- coef(gaussian_example_fit, type = "beta")
deltas <- coef(gaussian_example_fit, type = "delta")

}
\seealso{
Model outputs
\code{\link{as.data.frame.dynamitefit}()},
\code{\link{as.data.table.dynamitefit}()},
\code{\link{as_draws_df.dynamitefit}()},
\code{\link{confint.dynamitefit}()},
\code{\link{dynamite}()},
\code{\link{get_code}()},
\code{\link{get_data}()},
\code{\link{get_parameter_dims}()},
\code{\link{get_parameter_names}()},
\code{\link{get_parameter_types}()},
\code{\link{ndraws.dynamitefit}()},
\code{\link{nobs.dynamitefit}()}
}
\concept{output}
