% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydro_util.r
\name{NSE}
\alias{NSE}
\title{Nash Sutcliffe Efficiency of a model's output against observations}
\usage{
NSE(qsim, qobs, digits = 2)
}
\arguments{
\item{qsim}{Time series or vector of simulated values}

\item{qobs}{Time series or vector of observations}

\item{digits}{No. decimal places in returned value}
}
\value{
A number <= 1 indicating the goodness of fit of the simulated series against observations (1= perfect fit). Values of >0.8 are generally regarded as "behavioural"
}
\description{
Returns the the NSE (NSE, Nash and Sutcliffe, 1970) of the simulated values against the given observations.
}
\examples{
\dontrun{
require(dynatopmodel)

data(brompton)

# Goodness of fit for the storm simulation

NSE(brompton$storm.run$qsim, brompton$storm.run$qobs)
}
}
\references{
Nash, J., & Sutcliffe, J. V. (1970). River flow forecasting through conceptual models part I-A discussion of principles. Journal of hydrology, 10(3), 282-290.
}
\author{
Peter Metcalfe
}
