% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4_feature_network.R
\name{generate_feature_network}
\alias{generate_feature_network}
\alias{feature_network_default}
\title{Generate a target network}
\usage{
generate_feature_network(model)

feature_network_default(
  realnet = NULL,
  damping = 0.01,
  target_resampling = Inf,
  max_in_degree = 5
)
}
\arguments{
\item{model}{A dyngen intermediary model for which the transcription network has been generated with \code{\link[=generate_tf_network]{generate_tf_network()}}.}

\item{realnet}{The name of a gene regulatory network (GRN) in \link{realnets}.
If \code{NULL}, a random network will be sampled from \link{realnets}.
Alternatively, a custom GRN can be used by passing a weighted sparse matrix.}

\item{damping}{A damping factor used for the page rank algorithm used to subsample the realnet.}

\item{target_resampling}{How many targets / HKs to sample from the realnet per iteration.}

\item{max_in_degree}{The maximum in-degree of a target / HK.}
}
\value{
A dyngen model.
}
\description{
\code{\link[=generate_feature_network]{generate_feature_network()}} generates a network of target genes that are regulated
by the previously generated TFs, and also a separate network of housekeeping genes (HKs).
\code{\link[=feature_network_default]{feature_network_default()}} is used to configure parameters pertaining this process.
}
\examples{
model <- 
  initialise_model(
    backbone = backbone_bifurcating(),
    feature_network = feature_network_default(damping = 0.1)
  )
  
\donttest{
model <- model \%>\%
  generate_tf_network() \%>\%
  generate_feature_network()
  
plot_feature_network(model)
  
model <- model \%>\%
  generate_kinetics() \%>\%
  generate_gold_standard() \%>\%
  generate_cells() \%>\%
  generate_experiment()
dataset <- wrap_dataset(model)
}
}
