% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_feature_network}
\alias{plot_feature_network}
\title{Visualise the feature network of a model}
\usage{
plot_feature_network(
  model,
  show_tfs = TRUE,
  show_targets = TRUE,
  show_hks = FALSE
)
}
\arguments{
\item{model}{A dyngen intermediary model for which the feature network has been generated with \code{\link[=generate_feature_network]{generate_feature_network()}}.}

\item{show_tfs}{Whether or not to show the transcription factors.}

\item{show_targets}{Whether or not to show the targets.}

\item{show_hks}{Whether or not to show the housekeeping genes.}
}
\value{
A ggplot2 object.
}
\description{
Visualise the feature network of a model
}
\examples{
data("example_model")
plot_feature_network(example_model)
}
