% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynrRecipe.R
\name{prep.measurement}
\alias{prep.measurement}
\title{Prepare the measurement recipe}
\usage{
prep.measurement(values.load, params.load = NULL, values.exo = NULL,
  params.exo = NULL, values.int = NULL, params.int = NULL, obs.names,
  state.names, exo.names)
}
\arguments{
\item{values.load}{matrix of starting or fixed values for factor loadings. 
For models with regime-specific factor loadings provide a list of matrices of factor loadings.}

\item{params.load}{matrix or list of matrices. Contains parameter names of the factor loadings.}

\item{values.exo}{matrix or list of matrices. Contains starting/fixed values of the covariate regression slopes.}

\item{params.exo}{matrix or list of matrices. Parameter names of the covariate regression slopes.}

\item{values.int}{vector of intercept values specified as matrix or list of matrices. Contains starting/fixed values of the intercepts.}

\item{params.int}{vector of names for intercept parameters specified as a matrix or list of matrices.}

\item{obs.names}{vector of names for the observed variables in the order they appear in the measurement model.}

\item{state.names}{vector of names for the latent variables in the order they appear in the measurement model.}

\item{exo.names}{(optional) vector of names for the exogenous variables in the order they appear in the measurement model.}
}
\description{
Prepare the measurement recipe
}
\details{
The values.* arguments give the starting and fixed values for their respective matrices.
The params.* arguments give the free parameter labels for their respective matrices.
Numbers can be used as labels.
The number 0 and the character 'fixed' are reserved for fixed parameters.

When a single matrix is given to values.*, that matrix is not regime-switching.
Correspondingly, when a list of length r is given, that matrix is regime-switching with values and params for the r regimes in the elements of the list.
}
\seealso{
Methods that can be used include: \code{\link{print}}, \code{\link{printex}}, \code{\link{show}}
}

