% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynrPlot.R
\name{plot.dynrCook}
\alias{plot.dynrCook}
\title{Plot method for dynrCook objects}
\usage{
\method{plot}{dynrCook}(x, dynrModel, style = 1, names.state, names.observed,
  printDyn = TRUE, printMeas = TRUE, textsize = 4, ...)
}
\arguments{
\item{x}{dynrCook object}

\item{dynrModel}{model object}

\item{style}{The style of the plot in the first panel. If style is 1 (default), user-selected smoothed state variables are plotted. If style is 2, user-selected observed-versus-predicted values are plotted.}

\item{names.state}{(optional) The names of the states to be plotted, which should be a subset of the state.names slot of the measurement slot of dynrModel.}

\item{names.observed}{(optional) The names of the observed variables to be plotted, which should be a subset of the obs.names slot of the measurement slot of dynrModel.}

\item{printDyn}{A logical value indicating whether or not to plot the formulas for the dynamic model}

\item{printMeas}{A logical value indicating whether or not to plot the formulas for the measurement model}

\item{textsize}{numeric. Font size used in the plot.}

\item{...}{Further named arguments}
}
\value{
ggplot object.
}
\description{
Plot method for dynrCook objects
}
\details{
This is a wrapper around \code{\link{dynr.ggplot}}.  A great benefit of it is that it shows the model equations in a plot.
}

