% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynrRecipe.R
\name{prep.regimes}
\alias{prep.regimes}
\title{Recipe function for creating regime switching (Markov transition) functions}
\usage{
prep.regimes(values, params, covariates, deviation = FALSE, refRow)
}
\arguments{
\item{values}{matrix giving the values. Should have (number of Regimes) rows 
and (number of regimes x number of covariates) columns}

\item{params}{matrix of the same size as "values" consisting of the names of the parameters}

\item{covariates}{a vector of the names of the covariates to be used in the regime-switching functions}

\item{deviation}{logical. Whether to use the deviation form or not.  See Details.}

\item{refRow}{numeric. Which row is treated at the reference.  See Details.}
}
\description{
Recipe function for creating regime switching (Markov transition) functions
}
\details{
Note that each row of the transition probability matrix must sum to one. To accomplish this
fix at least one transition log odds parameter in each row of "values" (including its intercept 
and the regression slopes of all covariates) to 0.

When \code{deviation=FALSE}, the non-deviation form of the multinomial logistic regression is used. This form has a separate intercept term for each entry of the transition probability matrix (TPM). When \code{deviation=TRUE}, the deviation form of the multinomial logistic regression is used. This form has an intercept term that is common to each column of the TPM. The rows are then distinguished by their own individual deviations from the common intercept. The deviation form requires the same reference column constraint as the non-deviation form; however, the deviation form also requires one row to be indicated as the reference row (described below). By default the reference row is taken to be the same as the reference column.

The \code{refRow} argument determines which row is used as the intercept row. It is only
used in the deviation form (i.e. \code{deviation=TRUE}). In the deviation form, one row of \code{values} and \code{params} contains the intercepts, other rows contain deviations from these intercepts. The \code{refRow} argument says which row contains the intercept terms. The default behavior for \code{refRow} is to be the same as the reference column.  The reference column is automatically detected. If we have problems detecting which is the reference column, then we provide error messages that are as helpful as we can make them.
}
\examples{
#Regime-switching with no covariates (self-transition ID)
b <- prep.regimes(values=matrix(0, 3, 3), 
params=matrix(c(0, 'p1', 'p2', 'p3', 0, 'p4', 'p5', 'p6', 0), 3, 3))

#Regime switching with no covariates (second regime ID)
b <- prep.regimes(values=matrix(0, 3, 3), 
params=matrix(c('p1', 'p2', 'p3', 0, 0, 0, 'p4', 'p5', 'p6'), 3, 3))

#2 regimes with three covariates
b <- prep.regimes(values=matrix(c(0), 2, 8), 
params=matrix(c(paste0('p', 8:15), rep(0, 8)), 2, 8), 
covariates=c('x1', 'x2', 'x3'))
}

