% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap_data.R
\name{wrap_data}
\alias{wrap_data}
\alias{is_data_wrapper}
\title{A data wrapper for datasets and trajectories}
\usage{
wrap_data(
  id = NULL,
  cell_ids,
  cell_info = NULL,
  feature_ids = NULL,
  feature_info = NULL,
  ...
)

is_data_wrapper(dataset)
}
\arguments{
\item{id}{A unique identifier for the data. If \code{NULL}, a random string will be generated.}

\item{cell_ids}{The identifiers of the cells.}

\item{cell_info}{Optional meta-information pertaining the cells.}

\item{feature_ids}{The identifiers of the features.}

\item{feature_info}{Optional meta-information pertaining the features.}

\item{...}{Extra information to be stored in the wrapper.}

\item{dataset}{A dataset created by \code{\link[=wrap_data]{wrap_data()}} or \code{\link[=wrap_expression]{wrap_expression()}}}
}
\value{
A list containing \emph{id}, \emph{cell_ids} and \emph{cell_info} (if specified)
}
\description{
A data wrapper for datasets and trajectories
}
\examples{
dataset <- wrap_data(
  cell_ids = c("A", "B", "C")
)
dataset$cell_ids
}
\keyword{create_trajectory}
