// Generated by rstantools.  Do not edit by hand.

/*
    eDNAjoint is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    eDNAjoint is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with eDNAjoint.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.32.2
#include <stan/model/model_header.hpp>
namespace model_joint_binary_catchability_pois_namespace {
using stan::model::model_base_crtp;
using namespace stan::math;
stan::math::profile_map profiles__;
static constexpr std::array<const char*, 100> locations_array__ =
  {" (found before start of program)",
  " (in 'joint_binary_catchability_pois', line 22, column 4 to column 45)",
  " (in 'joint_binary_catchability_pois', line 23, column 4 to column 23)",
  " (in 'joint_binary_catchability_pois', line 24, column 4 to column 26)",
  " (in 'joint_binary_catchability_pois', line 25, column 4 to column 51)",
  " (in 'joint_binary_catchability_pois', line 26, column 4 to column 44)",
  " (in 'joint_binary_catchability_pois', line 29, column 2 to column 53)",
  " (in 'joint_binary_catchability_pois', line 30, column 2 to column 51)",
  " (in 'joint_binary_catchability_pois', line 31, column 2 to column 26)",
  " (in 'joint_binary_catchability_pois', line 59, column 2 to column 20)",
  " (in 'joint_binary_catchability_pois', line 60, column 2 to column 28)",
  " (in 'joint_binary_catchability_pois', line 61, column 2 to column 11)",
  " (in 'joint_binary_catchability_pois', line 62, column 2 to column 42)",
  " (in 'joint_binary_catchability_pois', line 63, column 2 to column 51)",
  " (in 'joint_binary_catchability_pois', line 34, column 4 to column 60)",
  " (in 'joint_binary_catchability_pois', line 35, column 4 to column 43)",
  " (in 'joint_binary_catchability_pois', line 33, column 24 to line 36, column 3)",
  " (in 'joint_binary_catchability_pois', line 33, column 2 to line 36, column 3)",
  " (in 'joint_binary_catchability_pois', line 39, column 6 to column 48)",
  " (in 'joint_binary_catchability_pois', line 38, column 15 to line 40, column 5)",
  " (in 'joint_binary_catchability_pois', line 38, column 2 to line 40, column 5)",
  " (in 'joint_binary_catchability_pois', line 65, column 2 to column 21)",
  " (in 'joint_binary_catchability_pois', line 67, column 2 to column 18)",
  " (in 'joint_binary_catchability_pois', line 70, column 4 to column 37)",
  " (in 'joint_binary_catchability_pois', line 72, column 7 to column 47)",
  " (in 'joint_binary_catchability_pois', line 71, column 23 to line 73, column 5)",
  " (in 'joint_binary_catchability_pois', line 71, column 4 to line 73, column 5)",
  " (in 'joint_binary_catchability_pois', line 69, column 23 to line 74, column 3)",
  " (in 'joint_binary_catchability_pois', line 69, column 2 to line 74, column 3)",
  " (in 'joint_binary_catchability_pois', line 79, column 7 to column 35)",
  " (in 'joint_binary_catchability_pois', line 80, column 7 to column 62)",
  " (in 'joint_binary_catchability_pois', line 82, column 11 to column 54)",
  " (in 'joint_binary_catchability_pois', line 81, column 26 to line 83, column 9)",
  " (in 'joint_binary_catchability_pois', line 81, column 7 to line 83, column 9)",
  " (in 'joint_binary_catchability_pois', line 78, column 26 to line 84, column 6)",
  " (in 'joint_binary_catchability_pois', line 78, column 5 to line 84, column 6)",
  " (in 'joint_binary_catchability_pois', line 77, column 2 to line 84, column 6)",
  " (in 'joint_binary_catchability_pois', line 86, column 4 to column 62)",
  " (in 'joint_binary_catchability_pois', line 85, column 15 to line 87, column 3)",
  " (in 'joint_binary_catchability_pois', line 85, column 2 to line 87, column 3)",
  " (in 'joint_binary_catchability_pois', line 89, column 4 to column 60)",
  " (in 'joint_binary_catchability_pois', line 88, column 15 to line 90, column 3)",
  " (in 'joint_binary_catchability_pois', line 88, column 2 to line 90, column 3)",
  " (in 'joint_binary_catchability_pois', line 94, column 7 to column 76)",
  " (in 'joint_binary_catchability_pois', line 93, column 22 to line 95, column 6)",
  " (in 'joint_binary_catchability_pois', line 93, column 5 to line 95, column 6)",
  " (in 'joint_binary_catchability_pois', line 92, column 2 to line 95, column 6)",
  " (in 'joint_binary_catchability_pois', line 44, column 6 to column 46)",
  " (in 'joint_binary_catchability_pois', line 43, column 17 to line 45, column 5)",
  " (in 'joint_binary_catchability_pois', line 43, column 4 to line 45, column 5)",
  " (in 'joint_binary_catchability_pois', line 47, column 8 to column 44)",
  " (in 'joint_binary_catchability_pois', line 46, column 18 to line 48, column 5)",
  " (in 'joint_binary_catchability_pois', line 46, column 4 to line 48, column 5)",
  " (in 'joint_binary_catchability_pois', line 52, column 11 to column 58)",
  " (in 'joint_binary_catchability_pois', line 51, column 25 to line 53, column 8)",
  " (in 'joint_binary_catchability_pois', line 51, column 7 to line 53, column 8)",
  " (in 'joint_binary_catchability_pois', line 50, column 4 to line 53, column 8)",
  " (in 'joint_binary_catchability_pois', line 55, column 2 to column 47)",
  " (in 'joint_binary_catchability_pois', line 56, column 2 to column 22)",
  " (in 'joint_binary_catchability_pois', line 2, column 4 to column 19)",
  " (in 'joint_binary_catchability_pois', line 3, column 4 to column 23)",
  " (in 'joint_binary_catchability_pois', line 4, column 4 to column 19)",
  " (in 'joint_binary_catchability_pois', line 5, column 10 to column 11)",
  " (in 'joint_binary_catchability_pois', line 5, column 4 to column 28)",
  " (in 'joint_binary_catchability_pois', line 6, column 10 to column 15)",
  " (in 'joint_binary_catchability_pois', line 6, column 4 to column 36)",
  " (in 'joint_binary_catchability_pois', line 7, column 10 to column 11)",
  " (in 'joint_binary_catchability_pois', line 7, column 4 to column 28)",
  " (in 'joint_binary_catchability_pois', line 8, column 4 to column 26)",
  " (in 'joint_binary_catchability_pois', line 9, column 4 to column 27)",
  " (in 'joint_binary_catchability_pois', line 10, column 10 to column 19)",
  " (in 'joint_binary_catchability_pois', line 10, column 4 to column 43)",
  " (in 'joint_binary_catchability_pois', line 11, column 10 to column 18)",
  " (in 'joint_binary_catchability_pois', line 11, column 4 to column 41)",
  " (in 'joint_binary_catchability_pois', line 12, column 10 to column 11)",
  " (in 'joint_binary_catchability_pois', line 12, column 4 to column 28)",
  " (in 'joint_binary_catchability_pois', line 13, column 10 to column 11)",
  " (in 'joint_binary_catchability_pois', line 13, column 4 to column 28)",
  " (in 'joint_binary_catchability_pois', line 14, column 10 to column 11)",
  " (in 'joint_binary_catchability_pois', line 14, column 4 to column 28)",
  " (in 'joint_binary_catchability_pois', line 15, column 10 to column 15)",
  " (in 'joint_binary_catchability_pois', line 15, column 4 to column 36)",
  " (in 'joint_binary_catchability_pois', line 16, column 10 to column 15)",
  " (in 'joint_binary_catchability_pois', line 16, column 4 to column 36)",
  " (in 'joint_binary_catchability_pois', line 17, column 4 to column 28)",
  " (in 'joint_binary_catchability_pois', line 18, column 4 to column 25)",
  " (in 'joint_binary_catchability_pois', line 19, column 11 to column 12)",
  " (in 'joint_binary_catchability_pois', line 19, column 13 to column 20)",
  " (in 'joint_binary_catchability_pois', line 19, column 4 to column 26)",
  " (in 'joint_binary_catchability_pois', line 22, column 10 to column 19)",
  " (in 'joint_binary_catchability_pois', line 25, column 10 to column 18)",
  " (in 'joint_binary_catchability_pois', line 26, column 27 to column 34)",
  " (in 'joint_binary_catchability_pois', line 29, column 8 to column 17)",
  " (in 'joint_binary_catchability_pois', line 30, column 8 to column 17)",
  " (in 'joint_binary_catchability_pois', line 31, column 18 to column 19)",
  " (in 'joint_binary_catchability_pois', line 59, column 9 to column 16)",
  " (in 'joint_binary_catchability_pois', line 60, column 9 to column 18)",
  " (in 'joint_binary_catchability_pois', line 62, column 9 to column 27)",
  " (in 'joint_binary_catchability_pois', line 62, column 28 to column 37)",
  " (in 'joint_binary_catchability_pois', line 63, column 8 to column 16)"};
#include <stan_meta_header.hpp>
class model_joint_binary_catchability_pois final : public model_base_crtp<model_joint_binary_catchability_pois> {
private:
  int S;
  int S_dna;
  int C;
  std::vector<int> L;
  std::vector<int> L_dna;
  std::vector<int> R;
  int Nloc_dna;
  int Nloc_trad;
  std::vector<int> trad_ind;
  std::vector<int> dna_ind;
  std::vector<int> E;
  std::vector<int> N;
  std::vector<int> K;
  std::vector<int> N_dna;
  std::vector<int> K_dna;
  std::vector<double> p10priors;
  int nparams;
  Eigen::Matrix<double,-1,-1> mat_data__;
  int log_lik_1dim__;
  int mu_1dim__;
  int mu_2dim__;
  Eigen::Map<Eigen::Matrix<double,-1,-1>> mat{nullptr, 0, 0};
public:
  ~model_joint_binary_catchability_pois() {}
  model_joint_binary_catchability_pois(stan::io::var_context& context__,
                                       unsigned int random_seed__ = 0,
                                       std::ostream* pstream__ = nullptr)
      : model_base_crtp(0) {
    int current_statement__ = 0;
    using local_scalar_t__ = double;
    boost::ecuyer1988 base_rng__ =
      stan::services::util::create_rng(random_seed__, 0);
    // suppress unused var warning
    (void) base_rng__;
    static constexpr const char* function__ =
      "model_joint_binary_catchability_pois_namespace::model_joint_binary_catchability_pois";
    // suppress unused var warning
    (void) function__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      current_statement__ = 59;
      context__.validate_dims("data initialization", "S", "int",
        std::vector<size_t>{});
      S = std::numeric_limits<int>::min();
      current_statement__ = 59;
      S = context__.vals_i("S")[(1 - 1)];
      current_statement__ = 59;
      stan::math::check_greater_or_equal(function__, "S", S, 1);
      current_statement__ = 60;
      context__.validate_dims("data initialization", "S_dna", "int",
        std::vector<size_t>{});
      S_dna = std::numeric_limits<int>::min();
      current_statement__ = 60;
      S_dna = context__.vals_i("S_dna")[(1 - 1)];
      current_statement__ = 60;
      stan::math::check_greater_or_equal(function__, "S_dna", S_dna, 0);
      current_statement__ = 61;
      context__.validate_dims("data initialization", "C", "int",
        std::vector<size_t>{});
      C = std::numeric_limits<int>::min();
      current_statement__ = 61;
      C = context__.vals_i("C")[(1 - 1)];
      current_statement__ = 61;
      stan::math::check_greater_or_equal(function__, "C", C, 1);
      current_statement__ = 62;
      stan::math::validate_non_negative_index("L", "S", S);
      current_statement__ = 63;
      context__.validate_dims("data initialization", "L", "int",
        std::vector<size_t>{static_cast<size_t>(S)});
      L = std::vector<int>(S, std::numeric_limits<int>::min());
      current_statement__ = 63;
      L = context__.vals_i("L");
      current_statement__ = 63;
      stan::math::check_greater_or_equal(function__, "L", L, 1);
      current_statement__ = 64;
      stan::math::validate_non_negative_index("L_dna", "S_dna", S_dna);
      current_statement__ = 65;
      context__.validate_dims("data initialization", "L_dna", "int",
        std::vector<size_t>{static_cast<size_t>(S_dna)});
      L_dna = std::vector<int>(S_dna, std::numeric_limits<int>::min());
      current_statement__ = 65;
      L_dna = context__.vals_i("L_dna");
      current_statement__ = 65;
      stan::math::check_greater_or_equal(function__, "L_dna", L_dna, 1);
      current_statement__ = 66;
      stan::math::validate_non_negative_index("R", "C", C);
      current_statement__ = 67;
      context__.validate_dims("data initialization", "R", "int",
        std::vector<size_t>{static_cast<size_t>(C)});
      R = std::vector<int>(C, std::numeric_limits<int>::min());
      current_statement__ = 67;
      R = context__.vals_i("R");
      current_statement__ = 67;
      stan::math::check_greater_or_equal(function__, "R", R, 1);
      current_statement__ = 68;
      context__.validate_dims("data initialization", "Nloc_dna", "int",
        std::vector<size_t>{});
      Nloc_dna = std::numeric_limits<int>::min();
      current_statement__ = 68;
      Nloc_dna = context__.vals_i("Nloc_dna")[(1 - 1)];
      current_statement__ = 68;
      stan::math::check_greater_or_equal(function__, "Nloc_dna", Nloc_dna, 0);
      current_statement__ = 69;
      context__.validate_dims("data initialization", "Nloc_trad", "int",
        std::vector<size_t>{});
      Nloc_trad = std::numeric_limits<int>::min();
      current_statement__ = 69;
      Nloc_trad = context__.vals_i("Nloc_trad")[(1 - 1)];
      current_statement__ = 69;
      stan::math::check_greater_or_equal(function__, "Nloc_trad", Nloc_trad,
        1);
      current_statement__ = 70;
      stan::math::validate_non_negative_index("trad_ind", "Nloc_trad",
        Nloc_trad);
      current_statement__ = 71;
      context__.validate_dims("data initialization", "trad_ind", "int",
        std::vector<size_t>{static_cast<size_t>(Nloc_trad)});
      trad_ind = std::vector<int>(Nloc_trad, std::numeric_limits<int>::min());
      current_statement__ = 71;
      trad_ind = context__.vals_i("trad_ind");
      current_statement__ = 71;
      stan::math::check_greater_or_equal(function__, "trad_ind", trad_ind, 0);
      current_statement__ = 72;
      stan::math::validate_non_negative_index("dna_ind", "Nloc_dna", Nloc_dna);
      current_statement__ = 73;
      context__.validate_dims("data initialization", "dna_ind", "int",
        std::vector<size_t>{static_cast<size_t>(Nloc_dna)});
      dna_ind = std::vector<int>(Nloc_dna, std::numeric_limits<int>::min());
      current_statement__ = 73;
      dna_ind = context__.vals_i("dna_ind");
      current_statement__ = 73;
      stan::math::check_greater_or_equal(function__, "dna_ind", dna_ind, 0);
      current_statement__ = 74;
      stan::math::validate_non_negative_index("E", "C", C);
      current_statement__ = 75;
      context__.validate_dims("data initialization", "E", "int",
        std::vector<size_t>{static_cast<size_t>(C)});
      E = std::vector<int>(C, std::numeric_limits<int>::min());
      current_statement__ = 75;
      E = context__.vals_i("E");
      current_statement__ = 75;
      stan::math::check_greater_or_equal(function__, "E", E, 0);
      current_statement__ = 76;
      stan::math::validate_non_negative_index("N", "S", S);
      current_statement__ = 77;
      context__.validate_dims("data initialization", "N", "int",
        std::vector<size_t>{static_cast<size_t>(S)});
      N = std::vector<int>(S, std::numeric_limits<int>::min());
      current_statement__ = 77;
      N = context__.vals_i("N");
      current_statement__ = 77;
      stan::math::check_greater_or_equal(function__, "N", N, 1);
      current_statement__ = 78;
      stan::math::validate_non_negative_index("K", "S", S);
      current_statement__ = 79;
      context__.validate_dims("data initialization", "K", "int",
        std::vector<size_t>{static_cast<size_t>(S)});
      K = std::vector<int>(S, std::numeric_limits<int>::min());
      current_statement__ = 79;
      K = context__.vals_i("K");
      current_statement__ = 79;
      stan::math::check_greater_or_equal(function__, "K", K, 0);
      current_statement__ = 80;
      stan::math::validate_non_negative_index("N_dna", "S_dna", S_dna);
      current_statement__ = 81;
      context__.validate_dims("data initialization", "N_dna", "int",
        std::vector<size_t>{static_cast<size_t>(S_dna)});
      N_dna = std::vector<int>(S_dna, std::numeric_limits<int>::min());
      current_statement__ = 81;
      N_dna = context__.vals_i("N_dna");
      current_statement__ = 81;
      stan::math::check_greater_or_equal(function__, "N_dna", N_dna, 1);
      current_statement__ = 82;
      stan::math::validate_non_negative_index("K_dna", "S_dna", S_dna);
      current_statement__ = 83;
      context__.validate_dims("data initialization", "K_dna", "int",
        std::vector<size_t>{static_cast<size_t>(S_dna)});
      K_dna = std::vector<int>(S_dna, std::numeric_limits<int>::min());
      current_statement__ = 83;
      K_dna = context__.vals_i("K_dna");
      current_statement__ = 83;
      stan::math::check_greater_or_equal(function__, "K_dna", K_dna, 0);
      current_statement__ = 84;
      context__.validate_dims("data initialization", "p10priors", "double",
        std::vector<size_t>{static_cast<size_t>(2)});
      p10priors = std::vector<double>(2,
                    std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 84;
      p10priors = context__.vals_r("p10priors");
      current_statement__ = 85;
      context__.validate_dims("data initialization", "nparams", "int",
        std::vector<size_t>{});
      nparams = std::numeric_limits<int>::min();
      current_statement__ = 85;
      nparams = context__.vals_i("nparams")[(1 - 1)];
      current_statement__ = 85;
      stan::math::check_greater_or_equal(function__, "nparams", nparams, 0);
      current_statement__ = 86;
      stan::math::validate_non_negative_index("mat", "C", C);
      current_statement__ = 87;
      stan::math::validate_non_negative_index("mat", "nparams", nparams);
      current_statement__ = 88;
      context__.validate_dims("data initialization", "mat", "double",
        std::vector<size_t>{static_cast<size_t>(C),
          static_cast<size_t>(nparams)});
      mat_data__ = Eigen::Matrix<double,-1,-1>::Constant(C, nparams,
                     std::numeric_limits<double>::quiet_NaN());
      new (&mat) Eigen::Map<Eigen::Matrix<double,-1,-1>>(mat_data__.data(),
        C, nparams);
      {
        std::vector<local_scalar_t__> mat_flat__;
        current_statement__ = 88;
        mat_flat__ = context__.vals_r("mat");
        current_statement__ = 88;
        pos__ = 1;
        current_statement__ = 88;
        for (int sym1__ = 1; sym1__ <= nparams; ++sym1__) {
          current_statement__ = 88;
          for (int sym2__ = 1; sym2__ <= C; ++sym2__) {
            current_statement__ = 88;
            stan::model::assign(mat, mat_flat__[(pos__ - 1)],
              "assigning variable mat", stan::model::index_uni(sym2__),
              stan::model::index_uni(sym1__));
            current_statement__ = 88;
            pos__ = (pos__ + 1);
          }
        }
      }
      current_statement__ = 89;
      stan::math::validate_non_negative_index("mu_trad_1", "Nloc_trad",
        Nloc_trad);
      current_statement__ = 90;
      stan::math::validate_non_negative_index("p_dna", "Nloc_dna", Nloc_dna);
      current_statement__ = 91;
      stan::math::validate_non_negative_index("q_trans", "nparams", nparams);
      current_statement__ = 92;
      stan::math::validate_non_negative_index("p11_trad", "Nloc_trad",
        Nloc_trad);
      current_statement__ = 93;
      stan::math::validate_non_negative_index("p_trad", "Nloc_trad",
        Nloc_trad);
      current_statement__ = 94;
      stan::math::validate_non_negative_index("coef", "C", C);
      current_statement__ = 95;
      stan::math::validate_non_negative_index("q", "nparams", nparams);
      current_statement__ = 96;
      log_lik_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 96;
      log_lik_1dim__ = ((C + S) + S_dna);
      current_statement__ = 96;
      stan::math::validate_non_negative_index("log_lik", "C + S + S_dna",
        log_lik_1dim__);
      current_statement__ = 97;
      mu_1dim__ = std::numeric_limits<int>::min();
      current_statement__ = 97;
      mu_1dim__ = (Nloc_dna + Nloc_trad);
      current_statement__ = 97;
      stan::math::validate_non_negative_index("mu", "Nloc_dna + Nloc_trad",
        mu_1dim__);
      current_statement__ = 98;
      mu_2dim__ = std::numeric_limits<int>::min();
      current_statement__ = 98;
      mu_2dim__ = (nparams + 1);
      current_statement__ = 98;
      stan::math::validate_non_negative_index("mu", "nparams + 1", mu_2dim__);
      current_statement__ = 99;
      stan::math::validate_non_negative_index("p11_dna", "Nloc_dna", Nloc_dna);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    num_params_r__ = Nloc_trad + 1 + 1 + Nloc_dna + nparams;
  }
  inline std::string model_name() const final {
    return "model_joint_binary_catchability_pois";
  }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.32.2",
             "stancflags = --allow-undefined"};
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI,
            stan::require_vector_like_t<VecR>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR>
  log_prob_impl(VecR& params_r__, VecI& params_i__, std::ostream*
                pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    static constexpr const char* function__ =
      "model_joint_binary_catchability_pois_namespace::log_prob";
    // suppress unused var warning
    (void) function__;
    try {
      std::vector<local_scalar_t__> mu_trad_1 =
        std::vector<local_scalar_t__>(Nloc_trad, DUMMY_VAR__);
      current_statement__ = 1;
      mu_trad_1 = in__.template read_constrain_lb<
                    std::vector<local_scalar_t__>, jacobian__>(0, lp__,
                    Nloc_trad);
      local_scalar_t__ beta = DUMMY_VAR__;
      current_statement__ = 2;
      beta = in__.template read_constrain_lb<local_scalar_t__, jacobian__>(0,
               lp__);
      local_scalar_t__ log_p10 = DUMMY_VAR__;
      current_statement__ = 3;
      log_p10 = in__.template read_constrain_ub<local_scalar_t__,
                  jacobian__>(0, lp__);
      std::vector<local_scalar_t__> p_dna =
        std::vector<local_scalar_t__>(Nloc_dna, DUMMY_VAR__);
      current_statement__ = 4;
      p_dna = in__.template read_constrain_lub<std::vector<local_scalar_t__>,
                jacobian__>(0, 1, lp__, Nloc_dna);
      Eigen::Matrix<local_scalar_t__,-1,1> q_trans =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(nparams, DUMMY_VAR__);
      current_statement__ = 5;
      q_trans = in__.template read_constrain_lb<
                  Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(-0.99999,
                  lp__, nparams);
      std::vector<local_scalar_t__> p11_trad =
        std::vector<local_scalar_t__>(Nloc_trad, DUMMY_VAR__);
      std::vector<local_scalar_t__> p_trad =
        std::vector<local_scalar_t__>(Nloc_trad, DUMMY_VAR__);
      Eigen::Matrix<local_scalar_t__,-1,1> coef =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(C, DUMMY_VAR__);
      current_statement__ = 17;
      for (int i = 1; i <= Nloc_trad; ++i) {
        current_statement__ = 14;
        stan::model::assign(p11_trad,
          (stan::model::rvalue(mu_trad_1, "mu_trad_1",
             stan::model::index_uni(i)) /
          (stan::model::rvalue(mu_trad_1, "mu_trad_1",
             stan::model::index_uni(i)) + stan::math::exp(beta))),
          "assigning variable p11_trad", stan::model::index_uni(i));
        current_statement__ = 15;
        stan::model::assign(p_trad,
          (stan::model::rvalue(p11_trad, "p11_trad",
             stan::model::index_uni(i)) + stan::math::exp(log_p10)),
          "assigning variable p_trad", stan::model::index_uni(i));
      }
      current_statement__ = 20;
      for (int k = 1; k <= C; ++k) {
        current_statement__ = 18;
        stan::model::assign(coef, (1 +
          stan::math::dot_product(
            stan::model::rvalue(mat, "mat", stan::model::index_uni(k)),
            q_trans)), "assigning variable coef", stan::model::index_uni(k));
      }
      current_statement__ = 6;
      stan::math::check_greater_or_equal(function__, "p11_trad", p11_trad, 0);
      current_statement__ = 6;
      stan::math::check_less_or_equal(function__, "p11_trad", p11_trad, 1);
      current_statement__ = 7;
      stan::math::check_greater_or_equal(function__, "p_trad", p_trad, 0);
      current_statement__ = 7;
      stan::math::check_less_or_equal(function__, "p_trad", p_trad, 1);
      current_statement__ = 8;
      stan::math::check_greater_or_equal(function__, "coef", coef, 0);
      {
        current_statement__ = 49;
        for (int j = 1; j <= C; ++j) {
          current_statement__ = 47;
          lp_accum__.add(stan::math::poisson_lpmf<propto__>(
                           stan::model::rvalue(E, "E",
                             stan::model::index_uni(j)),
                           (stan::model::rvalue(coef, "coef",
                              stan::model::index_uni(j)) *
                           stan::model::rvalue(mu_trad_1, "mu_trad_1",
                             stan::model::index_uni(
                               stan::model::rvalue(R, "R",
                                 stan::model::index_uni(j)))))));
        }
        current_statement__ = 52;
        for (int i = 1; i <= S; ++i) {
          current_statement__ = 50;
          lp_accum__.add(stan::math::binomial_lpmf<propto__>(
                           stan::model::rvalue(K, "K",
                             stan::model::index_uni(i)),
                           stan::model::rvalue(N, "N",
                             stan::model::index_uni(i)),
                           stan::model::rvalue(p_trad, "p_trad",
                             stan::model::index_uni(
                               stan::model::rvalue(L, "L",
                                 stan::model::index_uni(i))))));
        }
        current_statement__ = 56;
        if (stan::math::logical_gt(Nloc_dna, 0)) {
          current_statement__ = 55;
          for (int i = 1; i <= S_dna; ++i) {
            current_statement__ = 53;
            lp_accum__.add(stan::math::binomial_lpmf<propto__>(
                             stan::model::rvalue(K_dna, "K_dna",
                               stan::model::index_uni(i)),
                             stan::model::rvalue(N_dna, "N_dna",
                               stan::model::index_uni(i)),
                             stan::model::rvalue(p_dna, "p_dna",
                               stan::model::index_uni(
                                 stan::model::rvalue(L_dna, "L_dna",
                                   stan::model::index_uni(i))))));
          }
        }
        current_statement__ = 57;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(log_p10,
                         stan::model::rvalue(p10priors, "p10priors",
                           stan::model::index_uni(1)),
                         stan::model::rvalue(p10priors, "p10priors",
                           stan::model::index_uni(2))));
        current_statement__ = 58;
        lp_accum__.add(stan::math::normal_lpdf<propto__>(beta, 0, 10));
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
  }
  template <typename RNG, typename VecR, typename VecI, typename VecVar,
            stan::require_vector_like_vt<std::is_floating_point,
            VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral,
            VecI>* = nullptr, stan::require_vector_vt<std::is_floating_point,
            VecVar>* = nullptr>
  inline void
  write_array_impl(RNG& base_rng__, VecR& params_r__, VecI& params_i__,
                   VecVar& vars__, const bool
                   emit_transformed_parameters__ = true, const bool
                   emit_generated_quantities__ = true, std::ostream*
                   pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    static constexpr bool propto__ = true;
    // suppress unused var warning
    (void) propto__;
    double lp__ = 0.0;
    // suppress unused var warning
    (void) lp__;
    int current_statement__ = 0;
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    constexpr bool jacobian__ = false;
    static constexpr const char* function__ =
      "model_joint_binary_catchability_pois_namespace::write_array";
    // suppress unused var warning
    (void) function__;
    try {
      std::vector<double> mu_trad_1 =
        std::vector<double>(Nloc_trad,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 1;
      mu_trad_1 = in__.template read_constrain_lb<
                    std::vector<local_scalar_t__>, jacobian__>(0, lp__,
                    Nloc_trad);
      double beta = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 2;
      beta = in__.template read_constrain_lb<local_scalar_t__, jacobian__>(0,
               lp__);
      double log_p10 = std::numeric_limits<double>::quiet_NaN();
      current_statement__ = 3;
      log_p10 = in__.template read_constrain_ub<local_scalar_t__,
                  jacobian__>(0, lp__);
      std::vector<double> p_dna =
        std::vector<double>(Nloc_dna,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 4;
      p_dna = in__.template read_constrain_lub<std::vector<local_scalar_t__>,
                jacobian__>(0, 1, lp__, Nloc_dna);
      Eigen::Matrix<double,-1,1> q_trans =
        Eigen::Matrix<double,-1,1>::Constant(nparams,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 5;
      q_trans = in__.template read_constrain_lb<
                  Eigen::Matrix<local_scalar_t__,-1,1>, jacobian__>(-0.99999,
                  lp__, nparams);
      std::vector<double> p11_trad =
        std::vector<double>(Nloc_trad,
          std::numeric_limits<double>::quiet_NaN());
      std::vector<double> p_trad =
        std::vector<double>(Nloc_trad,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> coef =
        Eigen::Matrix<double,-1,1>::Constant(C,
          std::numeric_limits<double>::quiet_NaN());
      out__.write(mu_trad_1);
      out__.write(beta);
      out__.write(log_p10);
      out__.write(p_dna);
      out__.write(q_trans);
      if (stan::math::logical_negation(
            (stan::math::primitive_value(emit_transformed_parameters__) ||
            stan::math::primitive_value(emit_generated_quantities__)))) {
        return ;
      }
      current_statement__ = 17;
      for (int i = 1; i <= Nloc_trad; ++i) {
        current_statement__ = 14;
        stan::model::assign(p11_trad,
          (stan::model::rvalue(mu_trad_1, "mu_trad_1",
             stan::model::index_uni(i)) /
          (stan::model::rvalue(mu_trad_1, "mu_trad_1",
             stan::model::index_uni(i)) + stan::math::exp(beta))),
          "assigning variable p11_trad", stan::model::index_uni(i));
        current_statement__ = 15;
        stan::model::assign(p_trad,
          (stan::model::rvalue(p11_trad, "p11_trad",
             stan::model::index_uni(i)) + stan::math::exp(log_p10)),
          "assigning variable p_trad", stan::model::index_uni(i));
      }
      current_statement__ = 20;
      for (int k = 1; k <= C; ++k) {
        current_statement__ = 18;
        stan::model::assign(coef, (1 +
          stan::math::dot_product(
            stan::model::rvalue(mat, "mat", stan::model::index_uni(k)),
            q_trans)), "assigning variable coef", stan::model::index_uni(k));
      }
      current_statement__ = 6;
      stan::math::check_greater_or_equal(function__, "p11_trad", p11_trad, 0);
      current_statement__ = 6;
      stan::math::check_less_or_equal(function__, "p11_trad", p11_trad, 1);
      current_statement__ = 7;
      stan::math::check_greater_or_equal(function__, "p_trad", p_trad, 0);
      current_statement__ = 7;
      stan::math::check_less_or_equal(function__, "p_trad", p_trad, 1);
      current_statement__ = 8;
      stan::math::check_greater_or_equal(function__, "coef", coef, 0);
      if (emit_transformed_parameters__) {
        out__.write(p11_trad);
        out__.write(p_trad);
        out__.write(coef);
      }
      if (stan::math::logical_negation(emit_generated_quantities__)) {
        return ;
      }
      Eigen::Matrix<double,-1,1> q =
        Eigen::Matrix<double,-1,1>::Constant(nparams,
          std::numeric_limits<double>::quiet_NaN());
      Eigen::Matrix<double,-1,1> log_lik =
        Eigen::Matrix<double,-1,1>::Constant(log_lik_1dim__,
          std::numeric_limits<double>::quiet_NaN());
      double p10 = std::numeric_limits<double>::quiet_NaN();
      Eigen::Matrix<double,-1,-1> mu =
        Eigen::Matrix<double,-1,-1>::Constant(mu_1dim__, mu_2dim__,
          std::numeric_limits<double>::quiet_NaN());
      std::vector<double> p11_dna =
        std::vector<double>(Nloc_dna,
          std::numeric_limits<double>::quiet_NaN());
      current_statement__ = 21;
      p10 = stan::math::exp(log_p10);
      current_statement__ = 22;
      stan::model::assign(q, stan::math::add(q_trans, 1),
        "assigning variable q");
      current_statement__ = 28;
      for (int i = 1; i <= Nloc_trad; ++i) {
        current_statement__ = 23;
        stan::model::assign(mu,
          stan::model::rvalue(mu_trad_1, "mu_trad_1",
            stan::model::index_uni(i)), "assigning variable mu",
          stan::model::index_uni(
            stan::model::rvalue(trad_ind, "trad_ind",
              stan::model::index_uni(i))), stan::model::index_uni(1));
        current_statement__ = 26;
        for (int j = 1; j <= nparams; ++j) {
          current_statement__ = 24;
          stan::model::assign(mu,
            (stan::model::rvalue(mu_trad_1, "mu_trad_1",
               stan::model::index_uni(i)) *
            stan::model::rvalue(q, "q", stan::model::index_uni(j))),
            "assigning variable mu",
            stan::model::index_uni(
              stan::model::rvalue(trad_ind, "trad_ind",
                stan::model::index_uni(i))), stan::model::index_uni((j + 1)));
        }
      }
      current_statement__ = 36;
      if (stan::math::logical_gt(Nloc_dna, 0)) {
        current_statement__ = 35;
        for (int i = 1; i <= Nloc_dna; ++i) {
          current_statement__ = 29;
          stan::model::assign(p11_dna,
            (stan::model::rvalue(p_dna, "p_dna", stan::model::index_uni(i)) -
            p10), "assigning variable p11_dna", stan::model::index_uni(i));
          current_statement__ = 30;
          stan::model::assign(mu,
            ((stan::model::rvalue(p11_dna, "p11_dna",
                stan::model::index_uni(i)) * stan::math::exp(beta)) / (1 -
            stan::model::rvalue(p11_dna, "p11_dna", stan::model::index_uni(i)))),
            "assigning variable mu",
            stan::model::index_uni(
              stan::model::rvalue(dna_ind, "dna_ind",
                stan::model::index_uni(i))), stan::model::index_uni(1));
          current_statement__ = 33;
          for (int j = 1; j <= nparams; ++j) {
            current_statement__ = 31;
            stan::model::assign(mu,
              (stan::model::rvalue(mu, "mu",
                 stan::model::index_uni(
                   stan::model::rvalue(dna_ind, "dna_ind",
                     stan::model::index_uni(i))), stan::model::index_uni(1))
              * stan::model::rvalue(q, "q", stan::model::index_uni(j))),
              "assigning variable mu",
              stan::model::index_uni(
                stan::model::rvalue(dna_ind, "dna_ind",
                  stan::model::index_uni(i))),
              stan::model::index_uni((j + 1)));
          }
        }
      }
      current_statement__ = 39;
      for (int j = 1; j <= C; ++j) {
        current_statement__ = 37;
        stan::model::assign(log_lik,
          stan::math::poisson_lpmf<false>(
            stan::model::rvalue(E, "E", stan::model::index_uni(j)),
            (stan::model::rvalue(coef, "coef", stan::model::index_uni(j)) *
            stan::model::rvalue(mu_trad_1, "mu_trad_1",
              stan::model::index_uni(
                stan::model::rvalue(R, "R", stan::model::index_uni(j)))))),
          "assigning variable log_lik", stan::model::index_uni(j));
      }
      current_statement__ = 42;
      for (int i = 1; i <= S; ++i) {
        current_statement__ = 40;
        stan::model::assign(log_lik,
          stan::math::binomial_lpmf<false>(
            stan::model::rvalue(K, "K", stan::model::index_uni(i)),
            stan::model::rvalue(N, "N", stan::model::index_uni(i)),
            stan::model::rvalue(p_trad, "p_trad",
              stan::model::index_uni(
                stan::model::rvalue(L, "L", stan::model::index_uni(i))))),
          "assigning variable log_lik", stan::model::index_uni((C + i)));
      }
      current_statement__ = 46;
      if (stan::math::logical_gt(Nloc_dna, 0)) {
        current_statement__ = 45;
        for (int i = 1; i <= S_dna; ++i) {
          current_statement__ = 43;
          stan::model::assign(log_lik,
            stan::math::binomial_lpmf<false>(
              stan::model::rvalue(K_dna, "K_dna", stan::model::index_uni(i)),
              stan::model::rvalue(N_dna, "N_dna", stan::model::index_uni(i)),
              stan::model::rvalue(p_dna, "p_dna",
                stan::model::index_uni(
                  stan::model::rvalue(L_dna, "L_dna",
                    stan::model::index_uni(i))))),
            "assigning variable log_lik",
            stan::model::index_uni(((C + S) + i)));
        }
      }
      current_statement__ = 13;
      stan::math::check_greater_or_equal(function__, "p11_dna", p11_dna, 0);
      current_statement__ = 13;
      stan::math::check_less_or_equal(function__, "p11_dna", p11_dna, 1);
      out__.write(q);
      out__.write(log_lik);
      out__.write(p10);
      out__.write(mu);
      out__.write(p11_dna);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, typename VecI,
            stan::require_vector_t<VecVar>* = nullptr,
            stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void
  unconstrain_array_impl(const VecVar& params_r__, const VecI& params_i__,
                         VecVar& vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::deserializer<local_scalar_t__> in__(params_r__, params_i__);
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      std::vector<local_scalar_t__> mu_trad_1 =
        std::vector<local_scalar_t__>(Nloc_trad, DUMMY_VAR__);
      current_statement__ = 1;
      stan::model::assign(mu_trad_1,
        in__.read<std::vector<local_scalar_t__>>(Nloc_trad),
        "assigning variable mu_trad_1");
      out__.write_free_lb(0, mu_trad_1);
      local_scalar_t__ beta = DUMMY_VAR__;
      current_statement__ = 2;
      beta = in__.read<local_scalar_t__>();
      out__.write_free_lb(0, beta);
      local_scalar_t__ log_p10 = DUMMY_VAR__;
      current_statement__ = 3;
      log_p10 = in__.read<local_scalar_t__>();
      out__.write_free_ub(0, log_p10);
      std::vector<local_scalar_t__> p_dna =
        std::vector<local_scalar_t__>(Nloc_dna, DUMMY_VAR__);
      current_statement__ = 4;
      stan::model::assign(p_dna,
        in__.read<std::vector<local_scalar_t__>>(Nloc_dna),
        "assigning variable p_dna");
      out__.write_free_lub(0, 1, p_dna);
      Eigen::Matrix<local_scalar_t__,-1,1> q_trans =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(nparams, DUMMY_VAR__);
      current_statement__ = 5;
      stan::model::assign(q_trans,
        in__.read<Eigen::Matrix<local_scalar_t__,-1,1>>(nparams),
        "assigning variable q_trans");
      out__.write_free_lb(-0.99999, q_trans);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  template <typename VecVar, stan::require_vector_t<VecVar>* = nullptr>
  inline void
  transform_inits_impl(const stan::io::var_context& context__, VecVar&
                       vars__, std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    stan::io::serializer<local_scalar_t__> out__(vars__);
    int current_statement__ = 0;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    // suppress unused var warning
    (void) DUMMY_VAR__;
    try {
      current_statement__ = 1;
      context__.validate_dims("parameter initialization", "mu_trad_1",
        "double", std::vector<size_t>{static_cast<size_t>(Nloc_trad)});
      current_statement__ = 2;
      context__.validate_dims("parameter initialization", "beta", "double",
        std::vector<size_t>{});
      current_statement__ = 3;
      context__.validate_dims("parameter initialization", "log_p10",
        "double", std::vector<size_t>{});
      current_statement__ = 4;
      context__.validate_dims("parameter initialization", "p_dna", "double",
        std::vector<size_t>{static_cast<size_t>(Nloc_dna)});
      current_statement__ = 5;
      context__.validate_dims("parameter initialization", "q_trans",
        "double", std::vector<size_t>{static_cast<size_t>(nparams)});
      int pos__ = std::numeric_limits<int>::min();
      pos__ = 1;
      std::vector<local_scalar_t__> mu_trad_1 =
        std::vector<local_scalar_t__>(Nloc_trad, DUMMY_VAR__);
      current_statement__ = 1;
      mu_trad_1 = context__.vals_r("mu_trad_1");
      out__.write_free_lb(0, mu_trad_1);
      local_scalar_t__ beta = DUMMY_VAR__;
      current_statement__ = 2;
      beta = context__.vals_r("beta")[(1 - 1)];
      out__.write_free_lb(0, beta);
      local_scalar_t__ log_p10 = DUMMY_VAR__;
      current_statement__ = 3;
      log_p10 = context__.vals_r("log_p10")[(1 - 1)];
      out__.write_free_ub(0, log_p10);
      std::vector<local_scalar_t__> p_dna =
        std::vector<local_scalar_t__>(Nloc_dna, DUMMY_VAR__);
      current_statement__ = 4;
      p_dna = context__.vals_r("p_dna");
      out__.write_free_lub(0, 1, p_dna);
      Eigen::Matrix<local_scalar_t__,-1,1> q_trans =
        Eigen::Matrix<local_scalar_t__,-1,1>::Constant(nparams, DUMMY_VAR__);
      {
        std::vector<local_scalar_t__> q_trans_flat__;
        current_statement__ = 5;
        q_trans_flat__ = context__.vals_r("q_trans");
        current_statement__ = 5;
        pos__ = 1;
        current_statement__ = 5;
        for (int sym1__ = 1; sym1__ <= nparams; ++sym1__) {
          current_statement__ = 5;
          stan::model::assign(q_trans, q_trans_flat__[(pos__ - 1)],
            "assigning variable q_trans", stan::model::index_uni(sym1__));
          current_statement__ = 5;
          pos__ = (pos__ + 1);
        }
      }
      out__.write_free_lb(-0.99999, q_trans);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
    }
  }
  inline void
  get_param_names(std::vector<std::string>& names__, const bool
                  emit_transformed_parameters__ = true, const bool
                  emit_generated_quantities__ = true) const {
    names__ = std::vector<std::string>{"mu_trad_1", "beta", "log_p10",
                "p_dna", "q_trans"};
    if (emit_transformed_parameters__) {
      std::vector<std::string> temp{"p11_trad", "p_trad", "coef"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::string> temp{"q", "log_lik", "p10", "mu", "p11_dna"};
      names__.reserve(names__.size() + temp.size());
      names__.insert(names__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  get_dims(std::vector<std::vector<size_t>>& dimss__, const bool
           emit_transformed_parameters__ = true, const bool
           emit_generated_quantities__ = true) const {
    dimss__ = std::vector<std::vector<size_t>>{std::vector<size_t>{static_cast<
                                                                    size_t>(
                                                                    Nloc_trad)},
                std::vector<size_t>{}, std::vector<size_t>{},
                std::vector<size_t>{static_cast<size_t>(Nloc_dna)},
                std::vector<size_t>{static_cast<size_t>(nparams)}};
    if (emit_transformed_parameters__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(Nloc_trad)},
             std::vector<size_t>{static_cast<size_t>(Nloc_trad)},
             std::vector<size_t>{static_cast<size_t>(C)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
    if (emit_generated_quantities__) {
      std::vector<std::vector<size_t>>
        temp{std::vector<size_t>{static_cast<size_t>(nparams)},
             std::vector<size_t>{static_cast<size_t>(log_lik_1dim__)},
             std::vector<size_t>{},
             std::vector<size_t>{static_cast<size_t>(mu_1dim__),
               static_cast<size_t>(mu_2dim__)},
             std::vector<size_t>{static_cast<size_t>(Nloc_dna)}};
      dimss__.reserve(dimss__.size() + temp.size());
      dimss__.insert(dimss__.end(), temp.begin(), temp.end());
    }
  }
  inline void
  constrained_param_names(std::vector<std::string>& param_names__, bool
                          emit_transformed_parameters__ = true, bool
                          emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= Nloc_trad; ++sym1__) {
      param_names__.emplace_back(std::string() + "mu_trad_1" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "beta");
    param_names__.emplace_back(std::string() + "log_p10");
    for (int sym1__ = 1; sym1__ <= Nloc_dna; ++sym1__) {
      param_names__.emplace_back(std::string() + "p_dna" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= nparams; ++sym1__) {
      param_names__.emplace_back(std::string() + "q_trans" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= Nloc_trad; ++sym1__) {
        param_names__.emplace_back(std::string() + "p11_trad" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= Nloc_trad; ++sym1__) {
        param_names__.emplace_back(std::string() + "p_trad" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= C; ++sym1__) {
        param_names__.emplace_back(std::string() + "coef" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= nparams; ++sym1__) {
        param_names__.emplace_back(std::string() + "q" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= log_lik_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "log_lik" + '.' +
          std::to_string(sym1__));
      }
      param_names__.emplace_back(std::string() + "p10");
      for (int sym1__ = 1; sym1__ <= mu_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= mu_1dim__; ++sym2__) {
          param_names__.emplace_back(std::string() + "mu" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= Nloc_dna; ++sym1__) {
        param_names__.emplace_back(std::string() + "p11_dna" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline void
  unconstrained_param_names(std::vector<std::string>& param_names__, bool
                            emit_transformed_parameters__ = true, bool
                            emit_generated_quantities__ = true) const final {
    for (int sym1__ = 1; sym1__ <= Nloc_trad; ++sym1__) {
      param_names__.emplace_back(std::string() + "mu_trad_1" + '.' +
        std::to_string(sym1__));
    }
    param_names__.emplace_back(std::string() + "beta");
    param_names__.emplace_back(std::string() + "log_p10");
    for (int sym1__ = 1; sym1__ <= Nloc_dna; ++sym1__) {
      param_names__.emplace_back(std::string() + "p_dna" + '.' +
        std::to_string(sym1__));
    }
    for (int sym1__ = 1; sym1__ <= nparams; ++sym1__) {
      param_names__.emplace_back(std::string() + "q_trans" + '.' +
        std::to_string(sym1__));
    }
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= Nloc_trad; ++sym1__) {
        param_names__.emplace_back(std::string() + "p11_trad" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= Nloc_trad; ++sym1__) {
        param_names__.emplace_back(std::string() + "p_trad" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= C; ++sym1__) {
        param_names__.emplace_back(std::string() + "coef" + '.' +
          std::to_string(sym1__));
      }
    }
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= nparams; ++sym1__) {
        param_names__.emplace_back(std::string() + "q" + '.' +
          std::to_string(sym1__));
      }
      for (int sym1__ = 1; sym1__ <= log_lik_1dim__; ++sym1__) {
        param_names__.emplace_back(std::string() + "log_lik" + '.' +
          std::to_string(sym1__));
      }
      param_names__.emplace_back(std::string() + "p10");
      for (int sym1__ = 1; sym1__ <= mu_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= mu_1dim__; ++sym2__) {
          param_names__.emplace_back(std::string() + "mu" + '.' +
            std::to_string(sym2__) + '.' + std::to_string(sym1__));
        }
      }
      for (int sym1__ = 1; sym1__ <= Nloc_dna; ++sym1__) {
        param_names__.emplace_back(std::string() + "p11_dna" + '.' +
          std::to_string(sym1__));
      }
    }
  }
  inline std::string get_constrained_sizedtypes() const {
    return std::string("[{\"name\":\"mu_trad_1\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(Nloc_trad) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"log_p10\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"p_dna\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(Nloc_dna) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"q_trans\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(nparams) + "},\"block\":\"parameters\"},{\"name\":\"p11_trad\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(Nloc_trad) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"p_trad\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(Nloc_trad) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"coef\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(C) + "},\"block\":\"transformed_parameters\"},{\"name\":\"q\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(nparams) + "},\"block\":\"generated_quantities\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(log_lik_1dim__) + "},\"block\":\"generated_quantities\"},{\"name\":\"p10\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"mu\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(mu_1dim__) + ",\"cols\":" + std::to_string(mu_2dim__) + "},\"block\":\"generated_quantities\"},{\"name\":\"p11_dna\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(Nloc_dna) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"}]");
  }
  inline std::string get_unconstrained_sizedtypes() const {
    return std::string("[{\"name\":\"mu_trad_1\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(Nloc_trad) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"beta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"log_p10\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"p_dna\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(Nloc_dna) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"q_trans\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(nparams) + "},\"block\":\"parameters\"},{\"name\":\"p11_trad\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(Nloc_trad) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"p_trad\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(Nloc_trad) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"coef\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(C) + "},\"block\":\"transformed_parameters\"},{\"name\":\"q\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(nparams) + "},\"block\":\"generated_quantities\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" + std::to_string(log_lik_1dim__) + "},\"block\":\"generated_quantities\"},{\"name\":\"p10\",\"type\":{\"name\":\"real\"},\"block\":\"generated_quantities\"},{\"name\":\"mu\",\"type\":{\"name\":\"matrix\",\"rows\":" + std::to_string(mu_1dim__) + ",\"cols\":" + std::to_string(mu_2dim__) + "},\"block\":\"generated_quantities\"},{\"name\":\"p11_dna\",\"type\":{\"name\":\"array\",\"length\":" + std::to_string(Nloc_dna) + ",\"element_type\":{\"name\":\"real\"}},\"block\":\"generated_quantities\"}]");
  }
  // Begin method overload boilerplate
  template <typename RNG> inline void
  write_array(RNG& base_rng, Eigen::Matrix<double,-1,1>& params_r,
              Eigen::Matrix<double,-1,1>& vars, const bool
              emit_transformed_parameters = true, const bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((((Nloc_trad + 1) + 1) + Nloc_dna) +
      nparams);
    const size_t num_transformed = emit_transformed_parameters * (((Nloc_trad
      + Nloc_trad) + C));
    const size_t num_gen_quantities = emit_generated_quantities *
      (((((nparams + log_lik_1dim__) + 1) + (mu_1dim__ * mu_2dim__)) +
      Nloc_dna));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    std::vector<int> params_i;
    vars = Eigen::Matrix<double,-1,1>::Constant(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <typename RNG> inline void
  write_array(RNG& base_rng, std::vector<double>& params_r, std::vector<int>&
              params_i, std::vector<double>& vars, bool
              emit_transformed_parameters = true, bool
              emit_generated_quantities = true, std::ostream*
              pstream = nullptr) const {
    const size_t num_params__ = ((((Nloc_trad + 1) + 1) + Nloc_dna) +
      nparams);
    const size_t num_transformed = emit_transformed_parameters * (((Nloc_trad
      + Nloc_trad) + C));
    const size_t num_gen_quantities = emit_generated_quantities *
      (((((nparams + log_lik_1dim__) + 1) + (mu_1dim__ * mu_2dim__)) +
      Nloc_dna));
    const size_t num_to_write = num_params__ + num_transformed +
      num_gen_quantities;
    vars = std::vector<double>(num_to_write,
             std::numeric_limits<double>::quiet_NaN());
    write_array_impl(base_rng, params_r, params_i, vars,
      emit_transformed_parameters, emit_generated_quantities, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(Eigen::Matrix<T_,-1,1>& params_r, std::ostream* pstream = nullptr) const {
    Eigen::Matrix<int,-1,1> params_i;
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  template <bool propto__, bool jacobian__, typename T_> inline T_
  log_prob(std::vector<T_>& params_r, std::vector<int>& params_i,
           std::ostream* pstream = nullptr) const {
    return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
  }
  inline void
  transform_inits(const stan::io::var_context& context,
                  Eigen::Matrix<double,-1,1>& params_r, std::ostream*
                  pstream = nullptr) const final {
    std::vector<double> params_r_vec(params_r.size());
    std::vector<int> params_i;
    transform_inits(context, params_i, params_r_vec, pstream);
    params_r = Eigen::Map<Eigen::Matrix<double,-1,1>>(params_r_vec.data(),
                 params_r_vec.size());
  }
  inline void
  transform_inits(const stan::io::var_context& context, std::vector<int>&
                  params_i, std::vector<double>& vars, std::ostream*
                  pstream__ = nullptr) const {
    vars.resize(num_params_r__);
    transform_inits_impl(context, vars, pstream__);
  }
  inline void
  unconstrain_array(const std::vector<double>& params_constrained,
                    std::vector<double>& params_unconstrained, std::ostream*
                    pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = std::vector<double>(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
  inline void
  unconstrain_array(const Eigen::Matrix<double,-1,1>& params_constrained,
                    Eigen::Matrix<double,-1,1>& params_unconstrained,
                    std::ostream* pstream = nullptr) const {
    const std::vector<int> params_i;
    params_unconstrained = Eigen::Matrix<double,-1,1>::Constant(num_params_r__,
                             std::numeric_limits<double>::quiet_NaN());
    unconstrain_array_impl(params_constrained, params_i,
      params_unconstrained, pstream);
  }
};
}
using stan_model = model_joint_binary_catchability_pois_namespace::model_joint_binary_catchability_pois;
#ifndef USING_R
// Boilerplate
stan::model::model_base&
new_model(stan::io::var_context& data_context, unsigned int seed,
          std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_joint_binary_catchability_pois_namespace::profiles__;
}
#endif
#endif
