% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detection_calculate.R
\name{detection_calculate}
\alias{detection_calculate}
\title{Calculate the survey effort necessary to detect species presence, given the
species expected catch rate.}
\usage{
detection_calculate(
  model_fit,
  mu,
  cov_val = NULL,
  probability = 0.9,
  pcr_n = 3
)
}
\arguments{
\item{model_fit}{An object of class \code{stanfit}.}

\item{mu}{A numeric vector of species densities/capture rates. If multiple
traditional gear types are represented in the model, mu is the catch rate
of gear type 1.}

\item{cov_val}{A numeric vector indicating the values of site-level
covariates to use for prediction. Default is NULL.}

\item{probability}{A numeric value indicating the probability of detecting
presence. The default is 0.9.}

\item{pcr_n}{An integer indicating the number of PCR replicates per eDNA
sample. The default is 3.}
}
\value{
A summary table of survey efforts necessary to detect species
presence, given mu, for each survey type.
}
\description{
This function calculates the number of survey effort units to necessary
detect species presence using median estimated parameter values from
joint_model(). Detecting species presence is defined
as producing at least one true positive eDNA detection or catching at least
one individual. See more examples in the
\href{https://ednajoint.netlify.app/}{Package
Vignette}.
}
\note{
Before fitting the model, this function checks to ensure that the
function is possible given the inputs. These checks include:
\itemize{
\item  Input model fit is an object of class 'stanfit'.
\item  Input mu is a numeric vector.
\item  Input probability is a univariate numeric value.
\item  If model fit contains alpha, cov_val must be provided.
\item  Input cov_val is numeric.
\item  Input cov_val is the same length as the number of estimated
covariates.
\item  Input model fit has converged (i.e. no divergent transitions after
warm-up).
}

If any of these checks fail, the function returns an error message.
}
\examples{
\donttest{
# Ex. 1: Calculating necessary effort for detection with site-level
# covariates

# Load data
data(goby_data)

# Fit a model including 'Filter_time' and 'Salinity' site-level covariates
fit_cov <- joint_model(data = goby_data, cov = c('Filter_time','Salinity'),
                       family = "poisson", p10_priors = c(1,20), q = FALSE,
                       multicore = FALSE)

# Calculate at the mean covariate values
# (covariates are standardized, so mean = 0)
detection_calculate(fit_cov$model, mu = seq(from = 0.1, to = 1, by = 0.1),
                    cov_val = c(0,0), pcr_n = 3)

# Calculate mu_critical at salinity 0.5 z-scores greater than the mean
detection_calculate(fit_cov$model, mu = seq(from = 0.1, to = 1, by = 0.1),
                    cov_val = c(0,0.5), pcr_n = 3)

# Ex. 2: Calculating necessary effort for detection with multiple traditional
# gear types

# Load data
data(green_crab_data)

# Fit a model with no site-level covariates
fit_q <- joint_model(data = green_crab_data, cov = NULL, family = "negbin",
                     p10_priors = c(1,20), q = TRUE, multicore = FALSE)

# Calculate
detection_calculate(fit_q$model, mu = seq(from = 0.1, to = 1, by = 0.1),
                    cov_val = NULL, pcr_n = 3)

# Change probability of detecting presence to 0.95
detection_calculate(fit_q$model, mu = 0.1, cov_val = NULL,
                    probability = 0.95, pcr_n = 3)
}

}
