% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC_completeness.R
\name{completeness_heatmap}
\alias{completeness_heatmap}
\title{Completeness Heatmap}
\usage{
completeness_heatmap(
  data,
  id_var,
  annotation_tbl = NULL,
  method = 1,
  show_rownames = FALSE,
  ...
)
}
\arguments{
\item{data}{Data frame to be analysed.}

\item{id_var}{Character constant of row identifier variable name.}

\item{annotation_tbl}{Data frame containing variable annotation data. Column
1 should contain variable names, column 2 should contain an annotation
label.}

\item{method}{Integer between 1 and 3. Default: 1. See Details for more
information.}

\item{show_rownames}{Boolean. Should rownames be shown. Default: False.}

\item{...}{Parameters to be passed to \code{\link[pheatmap]{pheatmap}}.}
}
\value{
completeness heatmap
}
\description{
Produces a heatmap visualising completeness across a dataset.
}
\details{
\itemize{ \item Method 1: Missing values are numerically encoded with a
highly negative number, numerically distant from all values in \code{data},
using \code{\link[eHDPrep]{distant_neg_val}}. Values in categorical variables
are replaced with the number of unique values in the variable. Clustering
uses these values. Cells are coloured by presence (yellow = missing; blue =
present). \item Method 2: Same as Method 1 but cells are coloured by values
used to cluster. \item Method 3: Values in \code{data} are encoded as Boolean
values for clustering (present values = 1; missing values = 0). Cells are
coloured by presence (yellow = missing; blue = present). }
}
\note{
If the heatmap overlaps with other plots on the current device, it 
is recommended that users run the \code{\link[grid]{grid.newpage}} 
function to ensure a clean page is used for this plot.
}
\examples{
data(example_data)
completeness_heatmap(example_data,patient_id)

# with variable-level annotations
## create a dataframe containing variable annotations
tibble::tribble(~"var", ~"datatype",
"patient_id", "id",
"tumoursize", "numeric",
"t_stage", "ordinal_tstage",
"n_stage", "ordinal_nstage",
"diabetes", "factor",
"diabetes_type", "ordinal",
"hypertension", "factor",
"rural_urban", "factor",
"marital_status", "factor",
"SNP_a", "genotype",
"SNP_b", "genotype",
"free_text", "freetext") -> data_types

completeness_heatmap(example_data,patient_id, annotation_tbl = data_types)
}
\references{
Kolde R (2019). _pheatmap: Pretty Heatmaps_. R package version 1.0.12,
<https://CRAN.R-project.org/package=pheatmap>.
}
\seealso{
\code{\link[pheatmap]{pheatmap}}

Other measures of completeness: 
\code{\link{assess_completeness}()},
\code{\link{compare_completeness}()},
\code{\link{plot_completeness}()},
\code{\link{row_completeness}()},
\code{\link{variable_completeness}()}
}
\concept{measures of completeness}
