% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QC_clean.R
\name{encode_ordinals}
\alias{encode_ordinals}
\title{Encode ordinal variables}
\usage{
encode_ordinals(data, ord_levels, ..., strict_levels = TRUE)
}
\arguments{
\item{data}{A data frame, data frame extension (e.g. a tibble), or a lazy
data frame (e.g. from dbplyr or dtplyr).}

\item{ord_levels}{character vector containing values in desired order
(lowest to highest).}

\item{...}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> One or more unquoted
expressions separated by commas. Variable names can be used as if they
were positions in the data frame, so expressions like \code{x:y} can
be used to select a range of variables.}

\item{strict_levels}{logical constant. If \code{TRUE}, variables in
\code{...} which contain values other than \code{ord_levels} (including
\code{NA}) are not modified and a warning is given. If \code{FALSE},
values not in \code{ord_levels} are converted to \code{NA}.}
}
\value{
dataframe with specified variables encoded as ordered factors.
}
\description{
Converts character or factor variables in the input data frame to ordered factors
embedding numeric relationship between values while preserving value labels.
}
\examples{
data(example_data)
require(dplyr)
require(magrittr)
encode_ordinals(example_data, ord_levels = c("N0","N1","N2"), n_stage)

# Note: "unequivocal" is present in  t_stage but not in `ord_levels`.
# with `strict_levels` TRUE, t_stage is unmodified and a warning message is given:

encode_ordinals(example_data,
   ord_levels = c("T1","T2","T3a", "T3b", "T4"), strict_levels = TRUE, t_stage) \%>\%
   select(t_stage)
   
# with `strict_levels` FALSE, it is replaced with NA:

encode_ordinals(example_data,
   ord_levels = c("T1","T2","T3a", "T3b", "T4"), strict_levels = FALSE, t_stage) \%>\%
   select(t_stage)
}
