% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pts2poly_vertices.R
\name{pts2poly_vertices}
\alias{pts2poly_vertices}
\title{Create polygons from vertex coordinates}
\usage{
pts2poly_vertices(x, ...)
}
\arguments{
\item{x}{data frame with at least two columns;
the first two columns must contain longitude and latitude coordinates, respectively.
See 'Details' section for how additional columns are handled}

\item{...}{passed to \link[sf:sfc]{st_sfc},
e.g. for passing named argument \code{crs}}
}
\value{
Object of class \code{sfc} with the geometry type \code{POLYGON}
}
\description{
Create polygon(s) from a data frame with the coordinates of the polygon vertices
}
\details{
Vertices of different polygons must be demarcated by rows with values of \code{NA}
  in both the first and second columns (i.e. the longitude and latitude columns).

  All columns in \code{x} besides the first two columns are ignored.

  If a \code{crs} is not specified in \code{...},
  then the \code{crs} attribute of the polygon(s) will be \code{NULL}.
}
\examples{
x <- data.frame(
  lon = c(40, 40, 50, 50, 40),
  lat = c(0, 10, 10, 0, 0)
)
pts2poly_vertices(x, crs = 4326)

# Create an sf object
x <- data.frame(
  lon = c(40, 40, 50, 50, 40, NA, 20, 20, 30, 30, 20),
  lat = c(0, 10, 10, 0, 0, NA, 0, 10, 10, 0, 0)
)
sf::st_sf(Pred = 1:2, geometry = pts2poly_vertices(x, crs = 4326))

}
