% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ea_funcs.R
\name{calc.ec}
\alias{calc.ec}
\title{Calculates EC50 (or some other specified EC value)}
\usage{
calc.ec(eadrm.obj, ec.in = 0.5, ci.obj = NULL)
}
\arguments{
\item{eadrm.obj}{Fitted eadrm model object.}

\item{ec.in}{A value between 0 and 1 corresponding to the desired
proportion. Defaults to 0.5, in which case EC50 is computed.}

\item{ci.obj}{Output from eadrm.ci that is used to compute
confidence intervals. Defaults to NULL, in which case no confidence
intervals are computed.}
}
\value{
If no confidence intervals are requested, it returns the
concentration corresponding to the requested proportion.
Otherwise returns a list of three values ec.med, ec.l95, and
ec.u95, which correspond to the median concentration and the
corresponding lower/upper 95\% confidence bounds.
}
\description{
Calculates the concentration that induces a response corresponding
to a specific proportion between the baseline and maximum. It is most
commonly used to compute EC50.
}
\examples{
ea.fit <- eadrm(CarboA$y, CarboA$x)
calc.ec(ea.fit)
}
\seealso{
\code{\link{eadrm}}, \code{\link{eadrm.ci}}
}
