\name{movpotential_ews}
\alias{movpotential_ews}
\title{Moving Average Potential}
\usage{
movpotential_ews(X, param = NULL, bw = "nrd", bw.adjust = 1,
  detection.threshold = 0.1, std = 1, grid.size = 50, plot.cutoff = 0.5,
  plot.contours = TRUE, binwidth = 0.2, bins = NULL)
}
\arguments{
  \item{X}{a vector of the X observations of the state
  variable of interest}

  \item{param}{parameter values corresponding to the
  observations in X}

  \item{bw}{Bandwidth for smoothing kernels. Automatically
  determined by default.}

  \item{bw.adjust}{Bandwidth adjustment constant}

  \item{detection.threshold}{Threshold for local optima to
  be discarded.}

  \item{std}{Standard deviation.}

  \item{grid.size}{number of evaluation points; number of
  steps between min and max potential; also used as kernel
  window size}

  \item{plot.cutoff}{cuttoff for potential minima and
  maxima in visualization}

  \item{plot.contours}{Plot contours on the landscape
  visualization}

  \item{binwidth}{binwidth for contour plot}

  \item{bins}{bins for contour plot. Overrides binwidth if
  given}
}
\value{
A list with the following elements: pars values of the
covariate parameter as matrix; xis values of the x as
matrix; pots smoothed potentials; mins minima in the
densities (-potentials; neglecting local optima); maxs
maxima in densities (-potentials; neglecting local optima);
plot an object that displays the potential estimated in 2D
}
\description{
This function reconstructs a potential derived from data
along a gradient of a given parameter.
}
\details{
Arguments:
}
\examples{
X = c(rnorm(1000, mean = 0), rnorm(1000, mean = -2), rnorm(1000, mean = 2)); 
param = seq(0,5,length=3000); 
res <- movpotential_ews(X, param)
}
\author{
L. Lahti, E. van Nes, V. Dakos.
}
\references{
Hirota, M., Holmgren, M., van Nes, E.H. & Scheffer, M.
(2011). Global resilience of tropical forest and savanna to
critical transitions. \emph{Science}, 334, 232-235.
}
\seealso{
\code{\link{generic_ews}}; \code{\link{ddjnonparam_ews}};
\code{\link{bdstest_ews}};
\code{\link{sensitivity_ews}};\code{\link{surrogates_ews}};
\code{\link{ch_ews}}; \code{livpotential_ews}
}
\keyword{early-warning}

