% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{available_ele}
\alias{available_ele}
\title{Extract Unique Elements from a Column with Optional Filtering}
\usage{
available_ele(data, col_name, subset)
}
\arguments{
\item{data}{A data frame from which to extract values.}

\item{col_name}{A single string specifying the name of the target column.}

\item{subset}{An optional logical expression used to subset the data frame.
This expression is evaluated in the context of the \code{data}, so columns can be
referred to by their names directly (e.g., \code{Sepal.Length > 5}).}
}
\value{
A vector containing the unique, non-NA values from the specified
column after the optional filtering has been applied.
}
\description{
Retrieves the unique, non-missing values from a specified column of a data frame.
An optional expression can be provided to filter the rows of the data frame
before extracting the values.
}
\examples{
# Example 1: Get all unique species from the iris dataset
available_ele(iris, "Species")

# Example 2: Get unique species for flowers with Sepal.Length > 7
available_ele(iris, "Species", subset = Sepal.Length > 7)

# Example 3: Get unique carb values for cars with 6 cylinders
available_ele(mtcars, "carb", subset = cyl == 6)
}
