% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cens_find.R
\name{cens_find}
\alias{cens_find}
\alias{cens_find_dec}
\alias{cens_find_acs}
\title{Find a decennial or ACS census table with variables of interest}
\usage{
cens_find_dec(..., show = 2)

cens_find_acs(..., show = 4)
}
\arguments{
\item{...}{Variables to look for. These can be length-1 character vectors,
or, for convenience, can be left unquoted (see examples).}

\item{show}{How many matching tables to show. Increase this to show more
possible matches, at the cost of more output. Negative values will be
converted to positive but will suppress any printing.}
}
\value{
The codes for the top \code{show} tables, invisibly if \code{show} is positive.
}
\description{
This function uses fuzzy matching to help identify tables from the census
which contain variables of interest. Matched table codes are printed out,
along with the Census-provided table description, the parsed variable names,
and example table cells. The website \url{https://censusreporter.org/} may also
be useful in finding variables.
}
\examples{
cens_find_dec("sex", "age")
cens_find_dec(tenure, race)
cens_find_acs("income", "sex", show=3)
cens_find_acs("heath care", show=-1)

}
