% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkUniqueness.R
\name{checkUniqueness}
\alias{checkUniqueness}
\title{Check uniqueness of a variable.}
\usage{
checkUniqueness(GADSdat, varName, idVar)
}
\arguments{
\item{GADSdat}{\code{GADSdat} object imported via \code{eatGADS}.}

\item{varName}{Single string containing the variable name for which the check should be performed.}

\item{idVar}{Single string containing the identifier variable name.}
}
\value{
Returns either \code{TRUE} if the variable is unique within each value for \code{idVar} or a \code{GADSdat} object including
the not unique cases.
}
\description{
Function to check if a variable is unique for all cases of an identifier variable.
}
\details{
For example if missing values are multiple imputed and data is stored in a long format, checking the uniqueness of a variable
within an identifier can be tricky. This function automates this task.
}
\examples{
## create an example GADSdat
iris2 <- iris
iris2$Species <- as.character(iris2$Species)
gads <- import_DF(iris2, checkVarNames = FALSE)

## check uniqueness
checkUniqueness(gads, varName = "Sepal.Length", idVar = "Species")

}
