% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebirdst-loading.R
\name{get_species_path}
\alias{get_species_path}
\title{Get the data package path for a given species}
\usage{
get_species_path(species, path = rappdirs::user_data_dir("ebirdst"))
}
\arguments{
\item{species}{character; a single species given as a scientific name, common
name or six-letter species code (e.g. woothr). The full list of valid
species is can be viewed in the \link{ebirdst_runs} data frame included in this
package. To return the path to the example data, use "example_data".}

\item{path}{character; directory that the data were downloaded to. Defaults
to the suggested persistent data directory data directory:
rappdirs::user_data_dir("ebirdst")).}
}
\value{
The path to the data package directory.
}
\description{
This helper function can be used to get the path to a data package for a
given species to be used by the various loading functions.
}
\examples{
# download the example data
ebirdst_download("example_data")

# get the path
sp_path <- get_species_path("example_data")

# use it to load data
abd <- load_raster("abundance", sp_path)

\dontrun{
# get the path to the full data package for yellow-bellied sapsucker
# common name, scientific name, or species code can be used
get_species_path("Yellow-bellied Sapsucker")
get_species_path("Sphyrapicus varius")
get_species_path("yebsap")
}
}
