% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebirdst-sample.R
\name{sample_grid}
\alias{sample_grid}
\alias{sample_case_control}
\title{Spatial grid sampling methods}
\usage{
sample_grid(x, res, t_res, n = 1, replace = FALSE, jitter = TRUE)

sample_case_control(x, res, t_res, n = 1, replace = FALSE, jitter = TRUE)
}
\arguments{
\item{x}{data frame or \link{sf} point object; the points to subsample}

\item{res}{numeric; the size in meters of the grid to sample from. This can
be a 2 element vector indicating the x and y dimensions of the cells.}

\item{t_res}{numeric; the temporal resolution for sampling expressed as a
proportion of the year. For example, \code{7 / 375} would result in sampling
from each week.}

\item{n}{integer; the number of points to sample from each grid cell.}

\item{replace}{logical; whether to sample with replacement.}

\item{jitter}{logical; to avoid always using the same grid for sampling,
the grid can be jittered so that the origin is different each time this
function is called.}
}
\value{
Logical vector indicating which rows are selected.
}
\description{
Methods for subsampling data to deal with spatiotemporal bias in
observations. These functions define a grid in space and time, then sample
the given number of points from each cell. \code{\link[=sample_case_control]{sample_case_control()}}
additionally samples presence and absence independently.
}
\examples{
\dontrun{
# download example data
sp_path <- ebirdst_download("example_data", tifs_only = FALSE)

# test data to sample
test_data <- load_test_preds(sp_path, return_sf = TRUE)

# sample on a 100km, 1 month grid
s <- sample_grid(test_data, res = 100000, t_res = 1 / 12)
td_grid <- test_data[s, ]

# case control sampling independently samples presence and absence
s <- sample_case_control(test_data, res = 100000, t_res = 1 / 12)
td_cc <- test_data[s, ]

# grid sampling preserves the presence/absence ratio
table(test_data$obs > 0) / nrow(test_data)
table(td_grid$obs > 0) / nrow(td_grid)
# while case control sampling increases the prevelance of presences
table(td_cc$obs > 0) / nrow(td_cc)

# plot
library(sf)
p <- par(mar = c(0, 0, 0, 0))
plot(st_geometry(test_data), col = "black", pch = 19, cex = 0.2)
plot(st_geometry(td_cc), col = "red", pch = 19, cex = 0.5, add = TRUE)
par(p)
}
}
