% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.R
\name{load_ppm}
\alias{load_ppm}
\title{Load predictive performance metric (PPM) rasters}
\usage{
load_ppm(
  species,
  ppm = c("binary_f1", "binary_pr_auc", "occ_bernoulli_dev", "count_spearman",
    "log_count_pearson", "abd_poisson_dev", "abd_spearman", "log_abd_pearson"),
  path = ebirdst_data_dir()
)
}
\arguments{
\item{species}{character; the species to load data for, given as a scientific
name, common name or six-letter species code (e.g. "woothr"). The full list
of valid species is in the \link{ebirdst_runs} data frame included in this
package. To download the example dataset, use \code{"yebsap-example"}.}

\item{ppm}{character; the name of a single metric to load data for. See
Details for definitions of each metric.}

\item{path}{character; directory to download the data to. All downloaded
files will be placed in a sub-directory of this directory named for the
data version year, e.g. "2020" for the 2020 Status Data Products. Each
species' data package will then appear in a directory named with the eBird
species code. Defaults to a persistent data directory, which can be found
by calling \code{ebirdst_data_dir()}.}
}
\value{
A \link[terra:SpatRaster-class]{SpatRaster} object with the PPM data. For
migrants, rasters are weekly with  52 layers, where the layer names are the
dates (\code{MM-DD} format) of the midpoint of each week. For residents, a
single year round layer is returned.
}
\description{
eBird Status models are evaluated against a test set of eBird data not used
during model training and a suite of predictive performance metrics (PPMs)
are calculated. The PPMs for each base model are summarized to a 27 km
resolution raster grid, where the cell values are the average across all
models in the ensemble contributing to that cell. These data are available in
raster format provided \code{download_ppms = TRUE} was used when calling
\code{\link[=ebirdst_download_status]{ebirdst_download_status()}}.
}
\details{
Eight predictive performance metrics are provided:
\itemize{
\item \code{binary_f1}: F1-score comparing the model predictions converted to binary
with the observed detection/non-detection for the test checklists.
\item \code{binary_pr_auc}: the area on the precision-recall curve generated by
comparing the model predictions converted to binary with the observed
detection/non-detection for the test checklists.
\item \code{occ_bernoulli_dev}: Bernoulli deviance comparing the predicted occurrence
with the observed detection/non-detection for the test checklists.
\item \code{count_spearman}: Spearman's rank correlation coefficient comparing the
predicted count with the observed count for the subset of test checklists
on which the species was detected.
\item \code{log_count_pearson}: Pearson correlation coefficient comparing the
logarithm of the predicted count with the logarithm of the observed count
for the subset of test checklists on which the species was detected.
\item \code{abd_poisson_dev}: Poisson deviance comparing the predicted relative
abundance with the observed count for the full set of test checklists.
\item \code{abd_spearman}: Spearman's rank  correlation coefficient comparing the
predicted relative abundance with the observed count for the full set of
test checklists.
\item \code{log_abd_pearson}: Pearson correlation coefficient comparing the logarithm
of the predicted relative abundance with the logarithm of the observed
count for the full set of test checklists.
}
}
\examples{
\dontrun{
# download example data if hasn't already been downloaded
ebirdst_download_status("yebsap-example", download_ppms = TRUE)

# load area under the precision-recall curve PPM raster
load_ppm("yebsap-example", ppm = "binary_pr_auc")
}
}
