% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebnm_fns.R
\name{ebnm_generalized_binary}
\alias{ebnm_generalized_binary}
\title{Solve the EBNM problem using generalized binary priors}
\usage{
ebnm_generalized_binary(
  x,
  s = 1,
  mode = "estimate",
  scale = 0.1,
  g_init = NULL,
  fix_g = FALSE,
  output = ebnm_output_default(),
  control = NULL,
  ...
)
}
\arguments{
\item{x}{A vector of observations. Missing observations (\code{NA}s) are
not allowed.}

\item{s}{A vector of standard errors (or a scalar if all are equal).
Standard errors may not be exactly zero, and missing standard errors are
not allowed.}

\item{mode}{A scalar specifying the mode of the truncated normal component,
or \code{"estimate"} if the mode is to be estimated from the data (the
location of the point mass is fixed at zero).}

\item{scale}{A scalar specifying the ratio of the (untruncated) standard
deviation of the normal component to its mode. This ratio must be
fixed in advance (i.e., it is not possible to set \code{scale = "estimate"}
when using generalized binary priors).}

\item{g_init}{The prior distribution \eqn{g}. Usually this is left
unspecified (\code{NULL}) and estimated from the data. However, it can be
used in conjuction with \code{fix_g = TRUE} to fix the prior (useful, for
example, to do computations with the "true" \eqn{g} in simulations). If
\code{g_init} is specified but \code{fix_g = FALSE}, \code{g_init}
specifies the initial value of \eqn{g} used during optimization. When
supplied, \code{g_init} should be an object of class
\code{\link[ashr]{tnormalmix}} or an \code{ebnm} object in which the fitted
prior is an object of class \code{tnormalmix}.}

\item{fix_g}{If \code{TRUE}, fix the prior \eqn{g} at \code{g_init} instead
of estimating it.}

\item{output}{A character vector indicating which values are to be returned.
Function \code{ebnm_output_default()} provides the default return values, while
\code{ebnm_output_all()} lists all possible return values. See \strong{Value}
below.}

\item{control}{A list of control parameters to be passed to function
\code{\link[stats]{optimize}}.}

\item{...}{The following additional arguments act as control parameters for
the outer EM loops in the fitting algorithm. Each loop iteratively updates
parameters \eqn{w} (the
mixture proportion corresponding to the truncated normal component) and
\eqn{\mu} (the mode of the truncated normal component):
  \describe{
     \item{\code{wlist}}{A vector defining intervals of \eqn{w} for which
       optimal solutions will separately be found. For example, if
       \code{wlist = c(0, 0.5, 1)}, then two optimal priors will be found:
       one such that \eqn{w} is constrained to be less than 0.5 and one
       such that it is constrained to be greater than 0.5.}
     \item{\code{maxiter}}{A scalar specifying the maximum number of
       iterations to perform in each outer EM loop.}
     \item{\code{tol}}{A scalar specifying the convergence tolerance
       parameter for each outer EM loop.}
     \item{\code{mu_init}}{A scalar specifying the initial value of \eqn{\mu}
       to be used in each outer EM loop.}
     \item{\code{mu_range}}{A vector of length two specifying lower and
       upper bounds for possible values of \eqn{\mu}.}
   }}
}
\value{
An \code{ebnm} object. Depending on the argument to \code{output}, the
  object is a list containing elements:
    \describe{
      \item{\code{data}}{A data frame containing the observations \code{x}
        and standard errors \code{s}.}
      \item{\code{posterior}}{A data frame of summary results (posterior
        means, standard deviations, second moments, and local false sign
        rates).}
      \item{\code{fitted_g}}{The fitted prior \eqn{\hat{g}}.}
      \item{\code{log_likelihood}}{The optimal log likelihood attained,
        \eqn{L(\hat{g})}.}
      \item{\code{posterior_sampler}}{A function that can be used to
        produce samples from the posterior. The sampler takes a single
        parameter \code{nsamp}, the number of posterior samples to return per
        observation.}
     }
   S3 methods \code{coef}, \code{confint}, \code{fitted}, \code{logLik},
   \code{nobs}, \code{plot}, \code{predict}, \code{print}, \code{quantile},
   \code{residuals}, \code{simulate}, \code{summary}, and \code{vcov}
   have been implemented for \code{ebnm} objects. For details, see the
   respective help pages, linked below under \strong{See Also}.
}
\description{
Solves the empirical Bayes normal means (EBNM) problem using the family of
  nonnegative distributions consisting of mixtures where one component is a
  point mass at zero and the other is a truncated normal distribution with
  lower bound zero and nonzero mode. Typically, the mode is positive, with
  the ratio of the mode to the standard deviation taken to be large, so that
  posterior estimates are strongly shrunk towards one of two values (zero or
  the mode of the normal component).
  Identical to function \code{\link{ebnm}} with argument
  \code{prior_family = "generalized_binary"}.
  For details, see Liu et al. (2023), cited in \strong{References} below.
}
\references{
Yusha Liu, Peter Carbonetto, Jason Willwerscheid, Scott A Oakes,
  Kay F Macleod, and Matthew Stephens (2025). Dissecting tumor
  transcriptional heterogeneity from single-cell RNA-seq data by
  generalized binary covariance decomposition.  \emph{Nature Genetics}
  \strong{57}, 263--273. \doi{doi:10.1038/s41588-024-01997-z}.
}
\seealso{
See \code{\link{ebnm}} for examples of usage and model details.

  Available S3 methods include \code{\link{coef.ebnm}},
  \code{\link{confint.ebnm}},
  \code{\link{fitted.ebnm}}, \code{\link{logLik.ebnm}},
  \code{\link{nobs.ebnm}}, \code{\link{plot.ebnm}},
  \code{\link{predict.ebnm}}, \code{\link{print.ebnm}},
  \code{\link{print.summary.ebnm}}, \code{\link{quantile.ebnm}},
  \code{\link{residuals.ebnm}}, \code{\link{simulate.ebnm}},
  \code{\link{summary.ebnm}}, and \code{\link{vcov.ebnm}}.
}
