% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecd-fit-ts-conf-method.R
\name{ecd.fit_ts_conf}
\alias{ecd.fit_ts_conf}
\title{Timeseries fitting utility}
\usage{
ecd.fit_ts_conf(
  ts,
  conf,
  iter = 1000,
  FIT = FALSE,
  EPS = FALSE,
  eps_file = NULL,
  qa.fit = FALSE
)
}
\arguments{
\item{ts}{An xts object from either \code{ecd.data} or \code{ecd.df2ts}.}

\item{conf}{A nested list object, the configuration.}

\item{iter}{A length-one numeric. Number of maximum iterations. Default: 1000.}

\item{FIT}{Logical, indicating whether to call linear regression, default = FALSE}

\item{EPS}{Logical, indicating whether to save the plot to EPS, default = FALSE}

\item{eps_file}{File name for eps output}

\item{qa.fit}{Logical, qa the standardfit_fn once.}
}
\value{
Final ecd object
}
\description{
Fitting timeseries with provided conf as starting set of parameters.
}
\examples{
\dontrun{
d <- ecd.fit_ts_conf(ts, conf)
}
}
\keyword{fit}
\keyword{timeseries}
