% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R, R/add_.R
\name{e_lines}
\alias{e_lines}
\alias{e_lines_}
\title{Lines}
\usage{
e_lines(e, source_lon, source_lat, target_lon, target_lat,
  coord_system = "geo", name = NULL, rm_x = TRUE, rm_y = TRUE, ...)

e_lines_(e, source_lon, source_lat, target_lon, target_lat,
  coord_system = "geo", name = NULL, rm_x = TRUE, rm_y = TRUE, ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}}.}

\item{source_lon, source_lat, target_lon, target_lat}{coordinates.}

\item{coord_system}{Coordinate system to use, one of \code{geo}, or \code{cartesian2d}.}

\item{name}{name of the serie.}

\item{rm_x, rm_y}{Whether to remove x and y axis, defaults to \code{TRUE}.}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
Add lines.
}
\examples{
flights <- read.csv(
  paste0("https://raw.githubusercontent.com/plotly/datasets/",
         "master/2011_february_aa_flight_paths.csv")
)

flights \%>\% 
  e_charts() \%>\% 
  e_geo() \%>\% 
  e_lines(
    start_lon, 
    start_lat, 
    end_lon, 
    end_lat,
    name = "flights",
    lineStyle = list(normal = list(curveness = 0.3))
   )

}
\seealso{
\href{https://ecomfe.github.io/echarts-doc/public/en/option.html#series-lines}{Additional arguments}
}
