% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R, R/add_.R
\name{e_pie}
\alias{e_pie}
\alias{e_pie_}
\title{Pie}
\usage{
e_pie(e, serie, name = NULL, legend = TRUE, rm_x = TRUE, rm_y = TRUE, ...)

e_pie_(e, serie, name = NULL, legend = TRUE, rm_x = TRUE, rm_y = TRUE, ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or 
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{serie}{Column name of serie to plot.}

\item{name}{name of the serie.}

\item{legend}{Whether to add serie to legend.}

\item{rm_x, rm_y}{Whether to remove x and y axis, defaults to \code{TRUE}.}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
Draw pie and donut charts.
}
\examples{
mtcars \%>\% 
  head() \%>\% 
  dplyr::mutate(model = row.names(.)) \%>\% 
  e_charts(model) \%>\% 
  e_pie(carb)
  
# timeline
df <- data.frame(
  grp = c("A", "A", "A", "B", "B", "B"),
  labels = rep(LETTERS[1:3], 2),
  values = runif(6, 1, 5)
)

df \%>\% 
  group_by(grp) \%>\% 
  e_charts(labels, timeline = TRUE) \%>\% 
  e_pie(values)
  
}
\seealso{
\href{https://echarts.apache.org/en/option.html#series-pie}{Additional arguments}
}
