% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo.R
\name{e_geo_3d}
\alias{e_geo_3d}
\alias{e_geo_3d_}
\title{Geo 3D}
\usage{
e_geo_3d(e, serie, color, type = "world", rm_x = TRUE, rm_y = TRUE, ...)

e_geo_3d_(
  e,
  serie = NULL,
  color = NULL,
  type = "world",
  rm_x = TRUE,
  rm_y = TRUE,
  ...
)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{serie}{Column name of serie to plot.}

\item{color}{Color.}

\item{type}{Map type.}

\item{rm_x, rm_y}{Whether to remove x and y axis, defaults to \code{TRUE}.}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
Initialise geo 3D.
}
\examples{
choropleth <- data.frame(
  countries = c(
    "France",
    "Brazil",
    "China",
    "Russia",
    "Canada",
    "India",
    "United States",
    "Argentina",
    "Australia"
  ),
  height = runif(9, 1, 5),
  color = c(
    "#F7FBFF",
    "#DEEBF7",
    "#C6DBEF",
    "#9ECAE1",
    "#6BAED6",
    "#4292C6",
    "#2171B5",
    "#08519C",
    "#08306B"
  )
)

choropleth \%>\%
  e_charts(countries) \%>\%
  e_geo_3d(height, color)
}
\seealso{
\code{\link{e_country_names}},
\href{https://echarts.apache.org/en/option-gl.html#geo3D}{Additional arguments}
}
