% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echarty.R
\name{ecr.ebars}
\alias{ecr.ebars}
\title{Error bars}
\usage{
ecr.ebars(wt, df = NULL, hwidth = 6, ...)
}
\arguments{
\item{wt}{A widget to add error bars to, see \code{\link[htmlwidgets]{createWidget}}}

\item{df}{NULL(default) or data.frame with four or more columns ordered exactly (x,y,low,high,others).
When NULL, data is taken from wt's dataset where order should be the same (x,y,low,high,etc)}

\item{hwidth}{Half-width of error bar in pixels, default is 6.}

\item{...}{More parameters for \href{https://echarts.apache.org/en/option.html#series-custom.type}{custom serie}}
}
\value{
A widget with error bars added if successful, otherwise the input wt
}
\description{
Custom series to display error-bars for scatter,bar or line series
}
\details{
Grouped series are supported, but require the group column to be included in df. \cr
ecr.ebars are custom series, so \emph{ec.init(load='custom')} is required. \cr
ecr.ebars will add a chart legend and its own tooltip if none is provided.\cr
ecr.ebars should be set at the end, after all other series.
}
\examples{
tmp <- round(rnorm(24, sin(1:24/2)*10, .5))
df <- data.frame(x = 1:24, val = tmp, 
                 lower = round(rnorm(24, tmp -10, .5)),
                 upper = round(rnorm(24, tmp + 5, .8))
)
p <- df \%>\% ec.init(load='custom') \%>\% ecr.ebars()
p$x$opts$tooltip <- list(ey='')
p

}
